/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetaInfResourceFinder {
    private final List<Container> jarResourceContainers;
    private final Container container;

    public MetaInfResourceFinder(Container container) {
        this.container = container;
        this.jarResourceContainers = new ArrayList<Container>();
        try {
            WebModuleClassesInfo classesInfo = (WebModuleClassesInfo)this.container.adapt(WebModuleClassesInfo.class);
            if (classesInfo != null) {
                List containerInfos = classesInfo.getClassesContainers();
                for (ContainerInfo containerInfo : containerInfos) {
                    if (containerInfo.getType() != ContainerInfo.Type.WEB_INF_LIB) continue;
                    this.jarResourceContainers.add(containerInfo.getContainer());
                }
            }
        }
        catch (UnableToAdaptException e) {
            throw new IllegalStateException(e);
        }
    }

    public Entry findResourceInModule(String path, boolean searchLibJars) {
        return this.findResourceInModule(path, searchLibJars, false);
    }

    public Entry findResourceInModule(String path, boolean searchLibJars, boolean searchLibJarsOnly) {
        Entry resource;
        if (!searchLibJarsOnly && (resource = this.container.getEntry(path)) != null) {
            return resource;
        }
        if (searchLibJars) {
            for (Container jarContainer : this.jarResourceContainers) {
                Entry jarResource;
                if (jarContainer == null || (jarResource = jarContainer.getEntry("META-INF/resources" + path)) == null) continue;
                return jarResource;
            }
        }
        return null;
    }

    public Entry findResourceInModule(String path) {
        return this.findResourceInModule(path, true);
    }

    public List<Container> getJarResourceContainers() {
        return this.jarResourceContainers;
    }

    public List<URL> getJarResourceURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Container c : this.jarResourceContainers) {
            try {
                Container container;
                Entry entry = (Entry)c.adapt(Entry.class);
                if (entry == null || (container = (Container)entry.adapt(Container.class)) == null) continue;
                Collection cUrls = container.getURLs();
                urls.addAll(cUrls);
            }
            catch (UnableToAdaptException e) {
                throw new IllegalStateException(e);
            }
        }
        return urls;
    }
}

