/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.backchannellogout.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.openidconnect.backchannellogout.BackchannelLogoutException;
import com.ibm.ws.security.openidconnect.backchannellogout.internal.BackchannelLogoutJtiCache;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionCache;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionsStore;
import com.ibm.ws.security.openidconnect.jose4j.Jose4jValidator;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWTTokenValidationFailedException;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.JwtContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.security.openidconnect.backchannellogout.LogoutTokenValidator", service={}, property={"service.vendor=IBM"})
public class LogoutTokenValidator {
    private static TraceComponent tc = Tr.register(LogoutTokenValidator.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    public static final String EVENTS_MEMBER_NAME = "http://schemas.openid.net/event/backchannel-logout";
    private static SSLSupport SSL_SUPPORT = null;
    private static BackchannelLogoutJtiCache jtiCache = new BackchannelLogoutJtiCache(600000L);
    private ConvergedClientConfig config = null;
    private Jose4jUtil jose4jUtil = null;
    static final long serialVersionUID = -7708077531312248016L;

    @Reference
    protected void setSslSupport(SSLSupport sslSupport) {
        SSL_SUPPORT = sslSupport;
    }

    protected void unsetSslSupport() {
        SSL_SUPPORT = null;
    }

    public LogoutTokenValidator() {
    }

    public LogoutTokenValidator(ConvergedClientConfig config) {
        this.config = config;
        this.jose4jUtil = new Jose4jUtil(SSL_SUPPORT);
    }

    @FFDCIgnore(value={Exception.class})
    public JwtClaims validateToken(String logoutTokenString) throws BackchannelLogoutException {
        try {
            JwtContext jwtContext = this.jose4jUtil.validateJwtStructureAndGetContext(logoutTokenString, this.config);
            JwtClaims claims = this.jose4jUtil.validateJwsSignature(jwtContext, this.config);
            this.verifyAllRequiredClaimsArePresent(claims);
            this.verifyIssAudIatExpClaims(claims);
            this.verifySubAndOrSidPresent(claims);
            this.verifyEventsClaim(claims);
            this.verifyNonceClaimNotPresent(claims);
            this.doOptionalVerificationChecks(claims);
            return claims;
        }
        catch (Exception e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_TOKEN_ERROR", (Object[])new Object[]{e});
            throw new BackchannelLogoutException(errorMsg, e);
        }
    }

    void verifyAllRequiredClaimsArePresent(JwtClaims claims) throws MalformedClaimException, BackchannelLogoutException {
        Object events;
        String jti;
        NumericDate exp;
        NumericDate iat;
        List aud;
        ArrayList<String> missingClaims = new ArrayList<String>();
        String iss = claims.getIssuer();
        if (iss == null) {
            missingClaims.add("iss");
        }
        if ((aud = claims.getAudience()) == null || aud.isEmpty()) {
            missingClaims.add("aud");
        }
        if ((iat = claims.getIssuedAt()) == null) {
            missingClaims.add("iat");
        }
        if ((exp = claims.getExpirationTime()) == null) {
            missingClaims.add("exp");
        }
        if ((jti = claims.getJwtId()) == null) {
            missingClaims.add("jti");
        }
        if ((events = claims.getClaimValue("events")) == null) {
            missingClaims.add("events");
        }
        if (!missingClaims.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_MISSING_CLAIMS", (Object[])new Object[]{missingClaims});
            throw new BackchannelLogoutException(errorMsg);
        }
    }

    void verifyIssAudIatExpClaims(JwtClaims claims) throws IDTokenValidationFailedException, Exception, MalformedClaimException, JWTTokenValidationFailedException {
        Jose4jValidator validator = this.getJose4jValidator();
        validator.verifyIssForIdToken(claims.getIssuer());
        validator.verifyAudForIdToken(claims.getAudience());
        validator.verifyIatAndExpClaims(claims.getIssuedAt(), claims.getExpirationTime(), claims.getSubject());
    }

    Jose4jValidator getJose4jValidator() {
        return new Jose4jValidator(null, this.config.getClockSkewInSeconds(), OIDCClientAuthenticatorUtil.getIssuerIdentifier(this.config), this.config.getClientId(), this.config.getSignatureAlgorithm(), null);
    }

    void verifySubAndOrSidPresent(JwtClaims claims) throws MalformedClaimException, BackchannelLogoutException {
        String sub = claims.getSubject();
        String sid = (String)claims.getClaimValue("sid", String.class);
        if (sub == null && sid == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_MISSING_SUB_AND_SID", (Object[])new Object[0]);
            throw new BackchannelLogoutException(errorMsg);
        }
    }

    @FFDCIgnore(value={MalformedClaimException.class, ClassCastException.class})
    void verifyEventsClaim(JwtClaims claims) throws BackchannelLogoutException {
        try {
            Map events = (Map)claims.getClaimValue("events", Map.class);
            if (!events.containsKey(EVENTS_MEMBER_NAME)) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_EVENTS_CLAIM_MISSING_EXPECTED_MEMBER", (Object[])new Object[]{EVENTS_MEMBER_NAME, events});
                throw new BackchannelLogoutException(errorMsg);
            }
            try {
                Map errorMsg = (Map)events.get(EVENTS_MEMBER_NAME);
            }
            catch (ClassCastException e) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_EVENTS_MEMBER_VALUE_NOT_JSON", (Object[])new Object[]{EVENTS_MEMBER_NAME});
                throw new BackchannelLogoutException(errorMsg, e);
            }
        }
        catch (MalformedClaimException e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_EVENTS_CLAIM_WRONG_TYPE", (Object[])new Object[]{e.getMessage()});
            throw new BackchannelLogoutException(errorMsg, e);
        }
    }

    void verifyNonceClaimNotPresent(JwtClaims claims) throws BackchannelLogoutException {
        Object nonce = claims.getClaimValue("nonce");
        if (nonce != null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_CONTAINS_NONCE_CLAIM", (Object[])new Object[0]);
            throw new BackchannelLogoutException(errorMsg);
        }
    }

    void doOptionalVerificationChecks(JwtClaims claims) throws MalformedClaimException, BackchannelLogoutException {
        OidcSessionCache oidcSessionCache = this.config.getOidcSessionCache();
        this.verifyTokenWithSameJtiNotRecentlyReceived(claims);
        String sub = claims.getSubject();
        if (sub != null) {
            this.verifySubAndSidClaimsMatchRecentSession(claims, oidcSessionCache);
        } else {
            this.verifySidClaimMatchesRecentSession(claims, oidcSessionCache);
        }
    }

    void verifyTokenWithSameJtiNotRecentlyReceived(JwtClaims claims) throws MalformedClaimException, BackchannelLogoutException {
        String jti = claims.getJwtId();
        if (jti == null) {
            return;
        }
        String configId = this.config.getId();
        Object cachedJwtContext = jtiCache.get(jti, configId);
        if (cachedJwtContext != null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_DUP_JTI", (Object[])new Object[]{jti, configId});
            throw new BackchannelLogoutException(errorMsg);
        }
        long clockSkew = this.config.getClockSkew();
        jtiCache.put(jti, configId, claims, clockSkew);
    }

    void verifySubAndSidClaimsMatchRecentSession(JwtClaims claims, OidcSessionCache oidcSessionCache) throws MalformedClaimException, BackchannelLogoutException {
        String sid;
        String iss;
        String sub = HashUtils.digest((String)claims.getSubject());
        Map<String, OidcSessionsStore> subToSessionsMap = oidcSessionCache.getSubMap();
        if (!subToSessionsMap.containsKey(sub)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"NO_RECENT_SESSIONS_WITH_CLAIMS", (Object[])new Object[]{this.config.getId(), claims.getIssuer(), claims.getSubject(), claims.getStringClaimValue("sid")});
            throw new BackchannelLogoutException(errorMsg);
        }
        OidcSessionsStore sessionDataForSub = subToSessionsMap.get(sub);
        OidcSessionInfo matchingSession = this.findSessionMatchingIssAndSid(sessionDataForSub, iss = HashUtils.digest((String)claims.getIssuer()), sid = HashUtils.digest((String)claims.getStringClaimValue("sid")));
        if (matchingSession == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"NO_RECENT_SESSIONS_WITH_CLAIMS", (Object[])new Object[]{this.config.getId(), claims.getIssuer(), claims.getSubject(), claims.getStringClaimValue("sid")});
            throw new BackchannelLogoutException(errorMsg);
        }
    }

    OidcSessionInfo findSessionMatchingIssAndSid(OidcSessionsStore sessionDataForSub, String iss, String sid) {
        if (sid != null) {
            return this.findSessionMatchingIssAndNonNullSid(sessionDataForSub, iss, sid);
        }
        return this.findSessionMatchingOnlyIss(sessionDataForSub, iss);
    }

    OidcSessionInfo findSessionMatchingIssAndNonNullSid(OidcSessionsStore sessionDataForSub, String iss, String sid) {
        String sessionIss;
        OidcSessionInfo matchingSession = sessionDataForSub.getSession(sid);
        if (matchingSession != null && !iss.equals(sessionIss = matchingSession.getIss())) {
            matchingSession = null;
        }
        return matchingSession;
    }

    OidcSessionInfo findSessionMatchingOnlyIss(OidcSessionsStore sessionDataForSub, String iss) {
        List<OidcSessionInfo> sessions = sessionDataForSub.getSessions();
        for (OidcSessionInfo sessionInfo : sessions) {
            String sessionIss = sessionInfo.getIss();
            if (!iss.equals(sessionIss)) continue;
            return sessionInfo;
        }
        return null;
    }

    void verifySidClaimMatchesRecentSession(JwtClaims claims, OidcSessionCache oidcSessionCache) throws MalformedClaimException, BackchannelLogoutException {
        Map.Entry<String, OidcSessionsStore> entry;
        OidcSessionsStore sessionsStore;
        String sid = HashUtils.digest((String)claims.getStringClaimValue("sid"));
        if (sid == null) {
            return;
        }
        OidcSessionInfo matchingSession = null;
        String iss = HashUtils.digest((String)claims.getIssuer());
        Map<String, OidcSessionsStore> subToSessionsMap = oidcSessionCache.getSubMap();
        Iterator<Map.Entry<String, OidcSessionsStore>> iterator = subToSessionsMap.entrySet().iterator();
        while (iterator.hasNext() && (matchingSession = this.findSessionMatchingIssAndSid(sessionsStore = (entry = iterator.next()).getValue(), iss, sid)) == null) {
        }
        if (matchingSession == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"NO_RECENT_SESSIONS_WITH_CLAIMS", (Object[])new Object[]{this.config.getId(), claims.getIssuer(), claims.getSubject(), claims.getStringClaimValue("sid")});
            throw new BackchannelLogoutException(errorMsg);
        }
    }
}

