/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.MessageWriter;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemoteWriter
extends OutputStreamWriter {
    private static final TraceComponent tc = Tr.register(RemoteWriter.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    ByteArrayOutputStream underlyingsStream = null;
    WsocConnLink connLink = null;
    static final long serialVersionUID = 858475320837958143L;

    public RemoteWriter(ByteArrayOutputStream os) {
        super(os);
        this.underlyingsStream = os;
    }

    public void initialize(WsocConnLink link) {
        this.connLink = link;
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public void close() {
        byte[] ba;
        block3: {
            ba = null;
            try {
                super.flush();
                ba = this.underlyingsStream.toByteArray();
                super.close();
            }
            catch (IOException x) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("IOException caught while closing: " + x), (Object[])new Object[0]);
            }
        }
        WsByteBufferPoolManager bufferManager = this.connLink.getBufferManager();
        WsByteBuffer buffer = bufferManager.wrap(ba);
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeBuffer(buffer, OpcodeType.TEXT_WHOLE, MessageWriter.WRITE_TYPE.SYNC, null, -1, false, false);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            IOException ioe = new IOException("Data could not be written using WebSocket Writer object");
            this.connLink.callOnError(ioe);
        }
    }
}

