/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.filetransfer.routing.archiveExpander;

import com.ibm.ws.filetransfer.routing.archiveExpander.Java7UnixModeHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ArchiveExpander {
    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            System.exit(-1);
        } else if (!ArchiveExpander.expandArchive(args[0], args[1])) {
            System.exit(-1);
        }
    }

    public static boolean expandArchive(String sourcePath, String targetPath) {
        try {
            return ArchiveExpander.coreExpandArchive(sourcePath, targetPath);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static boolean coreExpandArchive(String sourcePath, String targetPath) throws IOException {
        boolean bl;
        ZipArchiveInputStream in = null;
        OutputStream out = null;
        try {
            File source = new File(sourcePath).getCanonicalFile();
            File target = new File(targetPath).getCanonicalFile();
            in = new ZipArchiveInputStream(ArchiveExpander.getInputStream(source));
            ZipArchiveEntry entry = in.getNextZipEntry();
            while (entry != null) {
                String outFilename = entry.getName();
                String targetPlusOutFile = target.getPath() + File.separator + outFilename;
                File targetFile = new File(targetPlusOutFile);
                char ending = outFilename.charAt(outFilename.length() - 1);
                if (ending == '/' || ending == '\\') {
                    ArchiveExpander.fileMkDirs(targetFile);
                    Java7UnixModeHelper.setPermissions(targetFile, entry.getUnixMode());
                } else {
                    int len;
                    ArchiveExpander.fileMkDirs(targetFile.getParentFile());
                    out = ArchiveExpander.getOutputStream(targetFile);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    Java7UnixModeHelper.setPermissions(targetFile, entry.getUnixMode());
                    out = null;
                }
                entry = in.getNextZipEntry();
            }
            in.close();
            in = null;
            bl = true;
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ArchiveExpander.tryToClose(out);
                ArchiveExpander.tryToClose(in);
                throw throwable;
            }
        }
        ArchiveExpander.tryToClose(out);
        ArchiveExpander.tryToClose(in);
        return bl;
    }

    public static boolean tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean fileMkDirs(final File target) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return target.mkdirs();
            }
        });
    }

    private static OutputStream getOutputStream(final File target) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(target);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public static InputStream getInputStream(final File target) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws FileNotFoundException {
                    return new FileInputStream(target);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public static boolean fileIsDirectory(final File target) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return target.isDirectory();
            }
        });
    }
}

