/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.TCPBaseRequestContext;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class TCPReadRequestContextImpl
extends TCPBaseRequestContext
implements TCPReadRequestContext,
FFDCSelfIntrospectable {
    private int jitAllocateSize = 0;
    private boolean jitAllocateAction = false;
    private TCPReadCompletedCallback callback;
    private static final TraceComponent tc = Tr.register(TCPReadRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    public TCPReadRequestContextImpl(TCPConnLink link) {
        super(link);
        this.setRequestTypeRead(true);
    }

    @Override
    public long read(long numBytes, int time) throws IOException {
        int timeout = time;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("read(" + numBytes + "," + timeout + ")"), (Object[])new Object[0]);
        }
        long bytesRead = 0L;
        this.getTCPConnLink().incrementNumReads();
        if (this.getConfig().getDumpStatsInterval() > 0) {
            this.getTCPConnLink().getTCPChannel().totalSyncReads.incrementAndGet();
        }
        this.checkForErrors(numBytes, false, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.getTCPConnLink().getSocketIOChannel().getSocket();
            Tr.event((TraceComponent)tc, (String)("read (sync) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        if (this.isAborted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Previously aborted, unable to perform read", (Object[])new Object[0]);
            }
            throw new IOException("Connection aborted by program");
        }
        if (timeout == -2) {
            this.immediateTimeout();
        } else if (timeout == -3) {
            this.abort();
            this.immediateTimeout();
        } else {
            if (timeout == 0) {
                timeout = this.getConfig().getInactivityTimeout();
            }
            bytesRead = this.processSyncReadRequest(numBytes, timeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("read: " + bytesRead));
        }
        return bytesRead;
    }

    protected abstract long processSyncReadRequest(long var1, int var3) throws IOException;

    @Override
    public VirtualConnection read(long numBytes, TCPReadCompletedCallback readCallback, boolean forceQueue, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("read(" + numBytes + ",..," + forceQueue + "," + timeout + ")"), (Object[])new Object[0]);
        }
        this.getTCPConnLink().incrementNumReads();
        if (this.getConfig().getDumpStatsInterval() > 0) {
            this.getTCPConnLink().getTCPChannel().totalAsyncReads.incrementAndGet();
        }
        this.checkForErrors(numBytes, true, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.getTCPConnLink().getSocketIOChannel().getSocket();
            Tr.event((TraceComponent)tc, (String)("read (async) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        VirtualConnection vc = null;
        if (this.isAborted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Previously aborted, unable to perform read", (Object[])new Object[0]);
            }
            if (null != readCallback) {
                IOException ioe = new IOException("Connection aborted by program");
                readCallback.error(this.getTCPConnLink().getVirtualConnection(), this, ioe);
            }
        } else {
            vc = this.readInternal(numBytes, readCallback, forceQueue, timeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("read: " + vc));
        }
        return vc;
    }

    protected VirtualConnection readInternal(long numBytes, TCPReadCompletedCallback readCallback, boolean forceQueue, int timeout) {
        if (timeout == -2) {
            this.immediateTimeout();
            return null;
        }
        if (timeout == -3) {
            this.abort();
            this.immediateTimeout();
            return null;
        }
        this.setIOAmount(numBytes);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setReadCompletedCallback(readCallback);
        this.setForceQueue(forceQueue);
        this.setTimeoutTime(timeout);
        return this.processAsyncReadRequest();
    }

    protected abstract VirtualConnection processAsyncReadRequest();

    private void checkForErrors(long numBytes, boolean isAsync, int _timeout) {
        if (_timeout == -2 || _timeout == -3) {
            return;
        }
        String errorMsg = null;
        if (this.getBuffer() != null && (this.getBuffer().getStatus() & 2) != 0) {
            this.getBuffer().setStatus(1);
        } else if (numBytes > Integer.MAX_VALUE) {
            errorMsg = "Number of bytes requested to read: " + numBytes + " exceeds the maximum allowed for one read";
        } else if (numBytes < 0L && !isAsync || numBytes < 1L && isAsync) {
            errorMsg = "Number of bytes requested to read: " + numBytes + " is less than minimum allowed (0 for sync, 1 for asynch)";
        } else if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
            if (numBytes > (long)this.getJITAllocateSize()) {
                errorMsg = "Number of bytes requested: " + numBytes + " exceeds JIT allocated buffer size: " + this.getJITAllocateSize();
            }
        } else if (this.getBuffers() == null || this.getBuffers().length == 0) {
            errorMsg = "No buffer(s) provided for reading data into";
        } else {
            WsByteBuffer[] wsBuffArray = this.getBuffers();
            long bytesAvail = 0L;
            for (int bufNum = 0; bufNum < wsBuffArray.length && wsBuffArray[bufNum] != null; ++bufNum) {
                bytesAvail += (long)(wsBuffArray[bufNum].limit() - wsBuffArray[bufNum].position());
            }
            if (numBytes > bytesAvail || bytesAvail == 0L) {
                errorMsg = "Number of bytes requested: " + numBytes + " exceeds space remaining in the buffers provided: " + bytesAvail;
            }
        }
        if (errorMsg != null) {
            IllegalArgumentException iae = new IllegalArgumentException(errorMsg);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)iae, (String)this.getClass().getName(), (String)"100", (Object)this);
            throw iae;
        }
    }

    @Override
    public void setJITAllocateSize(int numBytes) {
        this.jitAllocateSize = numBytes;
    }

    protected int getJITAllocateSize() {
        return this.jitAllocateSize;
    }

    @Override
    public boolean getJITAllocateAction() {
        return this.jitAllocateAction;
    }

    protected void setJITAllocateAction(boolean flag) {
        this.jitAllocateAction = flag;
    }

    protected void setReadCompletedCallback(TCPReadCompletedCallback cb) {
        this.callback = cb;
    }

    protected TCPReadCompletedCallback getReadCompletedCallback() {
        return this.callback;
    }

    protected abstract void immediateTimeout();

    public ByteBuffer[] preProcessReadBuffers() {
        int i;
        WsByteBuffer[] wsBuffArray = this.getBuffers();
        boolean containsNonDirect = false;
        for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
            if (wsBuffArray[i].isDirect() || !wsBuffArray[i].hasArray()) continue;
            containsNonDirect = true;
            break;
        }
        if (!containsNonDirect) {
            return this.getByteBufferArray();
        }
        try {
            for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
                ((WsByteBufferImpl)wsBuffArray[i]).setParmsToDirectBuffer();
            }
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading with non-WsByteBufferImpl, may hurt performance", (Object[])new Object[0]);
            }
            return this.getByteBufferArray();
        }
        this.setBuffersToDirect(wsBuffArray);
        return this.getByteBufferArrayDirect();
    }

    protected ByteBuffer preProcessOneReadBuffer() {
        WsByteBufferImpl wsBuffImpl = null;
        try {
            wsBuffImpl = (WsByteBufferImpl)this.getBuffer();
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading with a non-WsByteBufferImpl, may hurt performance", (Object[])new Object[0]);
            }
            return this.getBuffer().getWrappedByteBuffer();
        }
        if (!wsBuffImpl.isDirect() && wsBuffImpl.hasArray()) {
            wsBuffImpl.setParmsToDirectBuffer();
            return wsBuffImpl.oWsBBDirect;
        }
        return wsBuffImpl.getWrappedByteBufferNonSafe();
    }

    protected void postProcessReadBuffers(long dataRead) {
        if (this.getByteBufferArrayDirect() == null) {
            try {
                if (!this.getBuffer().isDirect()) {
                    ((WsByteBufferImpl)this.getBuffer()).copyFromDirectBuffer((int)dataRead);
                    return;
                }
                return;
            }
            catch (ClassCastException cce) {
                return;
            }
        }
        long dataLeft = dataRead;
        WsByteBuffer[] wsBuffArray = this.getBuffers();
        for (int i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
            int bufferSpace;
            block9: {
                bufferSpace = wsBuffArray[i].remaining();
                if (!wsBuffArray[i].isDirect()) {
                    try {
                        if ((long)bufferSpace < dataLeft) {
                            ((WsByteBufferImpl)wsBuffArray[i]).copyFromDirectBuffer(bufferSpace);
                            break block9;
                        }
                        ((WsByteBufferImpl)wsBuffArray[i]).copyFromDirectBuffer((int)dataLeft);
                        break;
                    }
                    catch (ClassCastException cce) {
                        return;
                    }
                }
                if ((long)bufferSpace >= dataLeft) break;
            }
            dataLeft -= (long)bufferSpace;
        }
    }

    @Override
    public List<String> introspect() {
        List<String> rc = super.introspect();
        String prefix = this.getClass().getSimpleName() + "@" + this.hashCode() + ": ";
        rc.add(prefix + "callback=" + this.callback);
        rc.add(prefix + "jitAllocateSize=" + this.jitAllocateSize);
        rc.add(prefix + "jitAllocateAction=" + this.jitAllocateAction);
        return rc;
    }

    @Override
    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }
}

