/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;

public abstract class AbstractHeaderGeneratingMessageHandler
extends AbstractMessageHandler {
    private boolean mustUnderstand;
    @Nullable
    private Predicate<MessageContext> mustUnderstandStrategy;
    private boolean effectiveMustUnderstand;
    @Nullable
    private String targetNode;
    @Nullable
    private Function<MessageContext, String> targetNodeStrategy;
    private String effectiveTargetNode;

    public void setMustUnderstand(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.mustUnderstand = flag;
    }

    public void setMustUnderstandStrategy(@Nullable Predicate<MessageContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.mustUnderstandStrategy = strategy;
    }

    protected boolean isEffectiveMustUnderstand() {
        return this.effectiveMustUnderstand;
    }

    public void setTargetNode(@Nullable String node) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.targetNode = StringSupport.trimOrNull((String)node);
    }

    public void setTargetNodeStrategy(@Nullable Function<MessageContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.targetNodeStrategy = strategy;
    }

    protected String getEffectiveTargetNode() {
        return this.effectiveTargetNode;
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.effectiveMustUnderstand = this.mustUnderstandStrategy != null ? this.mustUnderstandStrategy.test(messageContext) : this.mustUnderstand;
        this.effectiveTargetNode = this.targetNodeStrategy != null ? this.targetNodeStrategy.apply(messageContext) : this.targetNode;
        return true;
    }

    protected void decorateGeneratedHeader(@Nonnull MessageContext messageContext, @Nonnull XMLObject header) {
        if (this.isEffectiveMustUnderstand()) {
            SOAPMessagingSupport.addMustUnderstand(messageContext, header, true);
        }
        if (this.getEffectiveTargetNode() != null) {
            SOAPMessagingSupport.addTargetNode(messageContext, header, this.getEffectiveTargetNode());
        }
    }
}

