/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec.curves;

import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.security.spec.ECParameterSpec;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.crypto.ec.NamedCurve;

public class BasicNamedCurve
implements NamedCurve {
    @Nonnull
    private String name;
    @Nonnull
    private String oid;
    @Nonnull
    private ECParameterSpec params;

    public BasicNamedCurve(@Nonnull String objectIdentifier, @Nonnull String standardName, @Nonnull ECParameterSpec parameters) {
        this.oid = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)objectIdentifier), (String)"Curve identifier was null");
        this.name = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)standardName), (String)"Curve name was null");
        this.params = (ECParameterSpec)Constraint.isNotNull((Object)parameters, (String)"Curve parameters was null");
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ECParameterSpec getParameterSpec() {
        return this.params;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("OID", (Object)this.getObjectIdentifier()).toString();
    }
}

