/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.social;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JwtToken jwtToken;
    private final Map<String, Object> customProperties;
    private final Set<Claims> claimSet;
    private final String userInfo;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UserProfile(JwtToken jwtToken, Map<String, Object> customProperties, Claims claims) {
        this(jwtToken, customProperties, claims, null);
    }

    public UserProfile(JwtToken jwtToken, Map<String, Object> customProperties, Claims claims, String userInfo) {
        this.jwtToken = jwtToken;
        this.customProperties = customProperties;
        this.claimSet = new HashSet<Claims>();
        this.claimSet.add(claims);
        this.userInfo = userInfo;
    }

    public Set<Claims> getClaimSet() {
        HashSet<Claims> claimSetToReturn = new HashSet<Claims>();
        claimSetToReturn.addAll(this.claimSet);
        return claimSetToReturn;
    }

    public Claims getClaims() {
        Iterator<Claims> it = this.claimSet.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public String getAccessToken() {
        return (String)this.customProperties.get("access_token");
    }

    public String getRefreshToken() {
        return (String)this.customProperties.get("refresh_token");
    }

    public long getAccessTokenLifeTime() {
        Long expiresIn = (Long)this.customProperties.get("expires_in");
        if (expiresIn == null) {
            return 0L;
        }
        return expiresIn;
    }

    public String getSocialMediaName() {
        return (String)this.customProperties.get("social_media");
    }

    public String getScopes() {
        return (String)this.customProperties.get("scope");
    }

    public JwtToken getIdToken() {
        String id_token = (String)this.customProperties.get("id_token");
        if (id_token != null && !id_token.trim().isEmpty()) {
            return this.jwtToken;
        }
        return null;
    }

    public String getEncryptedAccessToken() {
        return (String)this.customProperties.get("encrypted_token");
    }

    public String getAccessTokenAlias() {
        return (String)this.customProperties.get("accessTokenAlias");
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.social.UserProfile", UserProfile.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    }
}

