/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.chfw;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transport.ActiveConfiguration;
import com.ibm.ws.sip.stack.transport.GenericChainBase;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.chfw.GenericChain;
import com.ibm.wsspi.channelfw.ChainEventListener;
import java.util.HashMap;
import java.util.Map;

public class GenericTCPChain
extends GenericChain
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(GenericTCPChain.class);
    private final boolean isTLS;
    private String tcpName;
    private String tlsName;

    public GenericTCPChain(GenericEndpointImpl owner, boolean isTls) {
        super(owner);
        this.isTLS = isTls;
    }

    @Override
    public void init(String endpointId, Object componentId, CHFWBundle cfBundle, String name) {
        String commmonName;
        String root = "TCP" + (this.isTLS ? "-ssl" : "");
        this.tcpName = commmonName = root + "_" + name + "_" + endpointId;
        this.tlsName = "TLS-" + commmonName;
        super.init(endpointId, componentId, cfBundle, name);
    }

    @Override
    protected ActiveConfiguration createActiveConfiguration() {
        Map<String, Object> map;
        this.getOwner();
        Map<String, Object> tcpOptions = GenericEndpointImpl.getTcpOptions();
        if (this.isTLS) {
            this.getOwner();
            map = GenericEndpointImpl.getSslOptions();
        } else {
            map = null;
        }
        Map<String, Object> sslOptions = map;
        Map<String, Object> endpointOptions = this.getOwner().getEndpointOptions();
        return new ActiveConfiguration(this.isTLS, tcpOptions, sslOptions, endpointOptions, this);
    }

    @Override
    protected void createChannels(ActiveConfiguration newConfig) {
        ChainData cd;
        ChannelData sipChannel;
        HashMap<Object, Object> chanProps;
        this.getOwner();
        Map<String, Object> tcpOptions = GenericEndpointImpl.getTcpOptions();
        EndPointInfo ep = this.endpointMgr.getEndPoint(this.getEndpointName());
        ep = this.endpointMgr.defineEndPoint(this.getEndpointName(), newConfig.configHost, newConfig.configPort);
        ChannelData tcpChannel = this.getChannel(this.tcpName);
        if (tcpChannel == null) {
            ChannelData sslChannel;
            chanProps = new HashMap<String, Object>(tcpOptions);
            String typeName = (String)tcpOptions.get("type");
            chanProps.put("endPointName", this.getEndpointName());
            chanProps.put("hostname", ep.getHost());
            chanProps.put("port", String.valueOf(ep.getPort()));
            tcpChannel = this.addChannel(this.getName(), typeName, chanProps, newConfig);
            if (this.isTLS && (sslChannel = this.getCfw().getChannel(this.tlsName)) == null) {
                sslChannel = this.addChannel(this.tlsName, "SSLChannel", chanProps, newConfig);
            }
        }
        if ((sipChannel = this.getChannel(this.sipChannelName)) == null) {
            chanProps = new HashMap();
            chanProps.put("endPointName", newConfig.endpointOptions.get("id"));
            if (this.isTLS) {
                chanProps.put("channelChainProtocolType", "tls");
            } else {
                chanProps.put("channelChainProtocolType", "tcp");
            }
            this.addChannel(this.sipChannelName, "SipInboundChannel", chanProps, newConfig);
        }
        if (null == (cd = this.getCfw().getChain(this.getChainName()))) {
            String[] chanList = this.isTLS ? new String[]{this.getName(), this.tlsName, this.sipChannelName} : new String[]{this.getName(), this.sipChannelName};
            this.addChain(chanList, cd, newConfig);
        }
    }

    @Override
    protected void rebuildTheChannel(ActiveConfiguration oldConfig, ActiveConfiguration newConfig) {
        this.stopChain(oldConfig.toString());
        if (newConfig.tcpChanged(oldConfig)) {
            this.removeChannel(this.tcpName);
        }
        if (newConfig.sslChanged(oldConfig)) {
            this.removeChannel(this.tlsName);
        }
    }

    @Override
    public String getName() {
        return this.tcpName;
    }

    @Override
    public void setupEventProps(Map<String, Object> eventProps) {
        eventProps.put("isTls", this.isTLS);
    }

    @Override
    public GenericChainBase.Type getType() {
        return this.isTLS ? GenericChainBase.Type.TLS : GenericChainBase.Type.TCP;
    }

    @Override
    public String getTransport() {
        return "tcp";
    }
}

