/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was.message;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.request.extended.IRequestExtended;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SecurityResourceCollection;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.router.SipServletInvokerListener;
import com.ibm.ws.sip.container.security.IPAuthenticator;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.EmptyHttpInboundConnection;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.wsspi.http.HttpInboundConnection;
import jain.protocol.ip.sip.SipParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class SipMessage
implements IRequestExtended,
IResponse,
Queueable {
    private static final LogMgr c_logger = Log.get(SipMessage.class);
    private static final String HOST = "host";
    private static final String ACCEPT = "accept";
    private static final String ASTERISK_SLASH_ASTERISK = "*/*";
    private static final String ACCEPT_LANGUAGE = "accept-language";
    private static final String EN_US = "en-us";
    private static final String ACCEPT_ENCODING = "accept-encoding";
    private static final String ENCODING = "gzip, deflate";
    private static final String USER_AGENT = "user-agent";
    private static final String BROWSERS = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
    private static final String CONNECTION = "connection";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_AUTHORIZATION = "Basic";
    private static final String COOKIE = "Cookie";
    private final ThreadLocal<SipParser> m_parser = new ThreadLocal<SipParser>(){

        @Override
        protected SipParser initialValue() {
            return new SipParser();
        }
    };
    private ParametersImpl m_cookies = null;
    private SipServletInvokerListener _listener;
    private SipServletRequest _request;
    private SipServletResponse _response;
    private String m_appPath = "";
    private int m_serverPort = -1;
    private String m_httpHost = "no host was set";
    private boolean m_isSSLEnabled;
    private static boolean m_isServerSecured = WSSecurityHelper.isServerSecurityEnabled();
    private SipAppDesc m_appDesc = null;
    private String m_servletName = "";
    private SipServletMessage m_message;
    private int m_statusCode;
    private Map<String, String> _wasRequestHeaders = new HashMap<String, String>();
    private Map<String, String> _wasResponseHeaders = new HashMap<String, String>();
    private TaskDurationMeasurer _sipContainerQueueDuration = null;
    private TaskDurationMeasurer _sipContainerApplicationCodeDuration = null;

    public void setup(SipServletRequest request, SipServletResponse response, SipAppDesc appDesc) {
        block11: {
            String cookie;
            block10: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "SipMessage", "created");
                }
                this.m_appDesc = appDesc;
                if (null != request) {
                    this._request = request;
                    this.m_message = request;
                }
                if (null != response) {
                    this._response = response;
                    this.m_message = response;
                    try {
                        Address toAddr = response.getAddressHeader("To");
                        URI uri = toAddr.getURI();
                        if (uri.isSipURI()) {
                            SipURI sipUri = (SipURI)uri;
                            String userName = sipUri.getUser();
                            StringBuffer user = new StringBuffer(16);
                            if (userName != null) {
                                user.append(userName);
                            }
                            user.append('@');
                            user.append(sipUri.getHost());
                            ThreadLocalStorage.setSipResponseToHeader(user.toString());
                        }
                    }
                    catch (ServletParseException e2) {
                        if (!c_logger.isErrorEnabled()) break block10;
                        c_logger.error("error.adding.to.header", "Request", null, (Throwable)((Object)e2));
                    }
                }
            }
            if ((cookie = this.m_message.getHeader(COOKIE)) != null && cookie.length() > 0) {
                SipParser parser = this.m_parser.get();
                parser.setSrc(cookie.toCharArray(), cookie.length());
                try {
                    this.m_cookies = parser.parseParametersMap(';', true, false);
                }
                catch (SipParseException e3) {
                    if (!c_logger.isErrorEnabled()) break block11;
                    c_logger.error("Error while trying to parse cookie", "Request", cookie, (Throwable)e3);
                }
            }
        }
        this.createWASHeaders();
    }

    public SipAppDesc getSipAppDesc() {
        return this.m_appDesc;
    }

    public String getAuthType() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getAuthType", "");
        }
        return null;
    }

    public int getContentLength() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getContentLength", "");
        }
        return 0;
    }

    public String getContentType() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getContentType", "");
        }
        return null;
    }

    public byte[] getCookieValue(String name) {
        if (this.m_cookies == null || !this.m_cookies.hasParameters()) {
            return null;
        }
        String str = this.m_cookies.getParameter(name);
        return str != null ? str.getBytes(Charset.defaultCharset()) : null;
    }

    public List getAllCookieValues(String cookieName) {
        if (this.m_cookies == null || !this.m_cookies.hasParameters()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> values = new ArrayList<String>(this.m_cookies.size());
        Iterator iter = this.m_cookies.getParameters();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            values.add(this.m_cookies.getParameter(key));
        }
        return values;
    }

    private String createLegalAuthorizationHeaderValue(String value, boolean hide) {
        if (value.startsWith(BASIC_AUTHORIZATION)) {
            if (c_logger.isTraceDebugEnabled() && !hide) {
                c_logger.traceDebug(this, "createLegalAuthorizationHeaderValue", "old[" + value + "]");
            }
            if (value.indexOf("cred") == -1) {
                return value;
            }
            StringBuffer newVal = new StringBuffer(BASIC_AUTHORIZATION);
            newVal.append(" ");
            newVal.append(value.substring(value.indexOf("\"") + 1, value.length() - 1));
            if (c_logger.isTraceDebugEnabled() && !hide) {
                c_logger.traceDebug(this, "createLegalAuthorizationHeaderValue", "new [" + newVal.toString() + "]");
            }
            return newVal.toString();
        }
        return value;
    }

    private void createWASHeaders() {
        String cookie;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getHeaders", "");
        }
        this._wasRequestHeaders.put(HOST, this.getServerName() + ":" + this.getServerPort());
        this._wasRequestHeaders.put(ACCEPT, ASTERISK_SLASH_ASTERISK);
        this._wasRequestHeaders.put(ACCEPT_LANGUAGE, EN_US);
        this._wasRequestHeaders.put(ACCEPT_ENCODING, ENCODING);
        this._wasRequestHeaders.put(USER_AGENT, BROWSERS);
        this._wasRequestHeaders.put(CONNECTION, KEEP_ALIVE);
        String authorization = this.m_message.getHeader(AUTHORIZATION);
        if (null != authorization) {
            boolean hideAuthorization = SIPTransactionStack.instance().getConfiguration().getHiddenHeaders().contains(AUTHORIZATION);
            String lahv = this.createLegalAuthorizationHeaderValue(authorization, hideAuthorization);
            this._wasRequestHeaders.put(AUTHORIZATION, lahv);
            if (c_logger.isTraceDebugEnabled() && !hideAuthorization) {
                c_logger.traceDebug(this, "getHeaders", "Authorization: " + lahv);
            }
        }
        if (null != (cookie = this.m_message.getHeader(COOKIE))) {
            this._wasRequestHeaders.put(COOKIE, cookie);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getHeaders", "Cookie: " + cookie);
            }
        }
    }

    public String getMethod() {
        if (m_isServerSecured) {
            if (IPAuthenticator.isIPAuthenticated(this.m_message)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getMethod", "Message authenticated, skipping authentication.");
                }
                return "GET";
            }
            SipAppDesc app = ThreadLocalStorage.getSipAppDesc();
            List collections = app.getSipServlet(this.getServletName()).getSecurityResourceCollections();
            int len = collections.size();
            for (int i = 0; i < len; ++i) {
                SecurityResourceCollection collection = (SecurityResourceCollection)collections.get(i);
                List methods = collection.getMethods();
                int mLen = methods.size();
                for (int j = 0; j < mLen; ++j) {
                    String method = (String)methods.get(j);
                    if (!this.m_message.getMethod().equalsIgnoreCase(method)) continue;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getMethod", "sip method[" + this.m_message.getMethod() + "] http POST");
                    }
                    return "POST";
                }
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getMethod", "sip method[" + this.m_message.getMethod() + "] http GET");
        }
        return "GET";
    }

    public String getProtocol() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getProtocol", "");
        }
        return "SIP";
    }

    public String getQueryString() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getQueryString", "");
        }
        return null;
    }

    public String getRemoteAddr() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRemoteAddr", "");
        }
        return null;
    }

    public String getRemoteHost() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRemoteHost", "");
        }
        return null;
    }

    public String getRemoteUser() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRemoteUser", "");
        }
        return null;
    }

    public String getRequestURI() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRequestURI", this.m_appPath);
        }
        return this.m_appPath;
    }

    public void setRequestURI(String uri) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setRequestURI", uri);
        }
        this.m_appPath = uri;
    }

    public String getScheme() {
        String scheme;
        String string = scheme = this.isSSL() ? "https" : "http";
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getScheme", scheme);
        }
        return scheme;
    }

    public String getServletName() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getServletName", this.m_servletName);
        }
        return this.m_servletName;
    }

    public void setServletName(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setServletName", name);
        }
        this.m_servletName = name;
    }

    public String getServerName() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getServerName", "Server: " + this.m_httpHost);
        }
        return this.m_httpHost;
    }

    public int getServerPort() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getServerPort", "Port: " + this.m_serverPort);
        }
        return this.m_serverPort;
    }

    public void setServerPort(int port) {
        this.m_serverPort = port;
    }

    public byte[] getSessionId() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSessionId", "");
        }
        return null;
    }

    public boolean isSSL() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isSSL", "SSL Enabled: " + this.m_isSSLEnabled);
        }
        return this.m_isSSLEnabled;
    }

    public void prepareForWrite() {
        SipServletRequest request;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "prepareForWrite", String.valueOf(this.m_statusCode));
        }
        if (null == (request = this._request)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "prepareForWrite", "NO REQUEST!!");
            }
            return;
        }
        if (this.m_statusCode == 401 || this.m_statusCode == 407 || this.m_statusCode == 403 || this.m_statusCode == 404) {
            if (!request.isCommitted() && !request.getMethod().equals("ACK")) {
                SipServletResponse response = request.createResponse(this.m_statusCode);
                for (String key : this._wasResponseHeaders.keySet()) {
                    String value = this._wasResponseHeaders.get(key);
                    if (c_logger.isTraceDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer("name: ");
                        buffer.append(key);
                        buffer.append(" value: ");
                        buffer.append(value);
                        c_logger.traceDebug(this, "prepareForWrite", buffer.toString());
                    }
                    response.addHeader(key, value);
                }
                if (c_logger.isTraceDebugEnabled()) {
                    if (this.m_statusCode == 404 && c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "prepareForWrite", "Warning!!! the Web Container failed to find " + this.getRequestURI() + " Check that servlet mapping exists in web.xml");
                    }
                    c_logger.traceDebug(this, "prepareForWrite", "Sending a " + this.m_statusCode + " Automatic response by the container");
                }
                this.sendResponse(response);
            } else {
                c_logger.traceDebug(this, "prepareForWrite", this.m_statusCode + "  response already sent");
            }
        } else if (this.m_statusCode != 200) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buffer = new StringBuffer("Failure, status code: ");
                buffer.append(this.m_statusCode);
                buffer.append(" \nRequest:");
                buffer.append(this._request);
                buffer.append("\nResponse:\n");
                buffer.append(this._response);
                c_logger.traceDebug(this, "prepareForWrite", buffer.toString());
            }
            if (!request.isCommitted() && !request.getMethod().equals("ACK")) {
                SipServletResponse response = request.createResponse(this.m_statusCode);
                this.sendResponse(response);
            }
        }
    }

    private void sendResponse(SipServletResponse response) {
        block2: {
            try {
                response.send();
            }
            catch (IOException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{response};
                c_logger.error("error.sending.response.from.prepare.for.write", "Request", args, (Throwable)e2);
            }
        }
    }

    public void setHost(String httpHost) {
        this.m_httpHost = httpHost;
    }

    public void setSSLEnbaled(boolean isSSLEnabled) {
        this.m_isSSLEnabled = isSSLEnabled;
    }

    public void setFlushMode(boolean b) {
    }

    public boolean getFlushMode() {
        return false;
    }

    public void flushBufferedContent() {
    }

    public String getHeader(String headerName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getHeader", "headerName: " + headerName);
        }
        return this._wasRequestHeaders.get(headerName);
    }

    public Enumeration getHeaders(String headerName) {
        String val;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getHeaders enumeration", "headerName: " + headerName);
        }
        if ((val = this._wasRequestHeaders.get(headerName)) != null) {
            Vector<String> v = new Vector<String>(1);
            v.add(val);
            return v.elements();
        }
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public long getDateHeader(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getDateHeader", "name: " + name);
        }
        return 0L;
    }

    public int getIntHeader(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getIntHeader", "name: " + name);
        }
        return 0;
    }

    public void clearHeaders() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "clearHeaders", "");
        }
    }

    public Enumeration getHeaderNames() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getHeaderNames", "");
        }
        return null;
    }

    public int getRemotePort() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getRemotePort", "");
        }
        return 0;
    }

    public InputStream getInputStream() throws IOException {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getInputStream", "");
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
    }

    public String getLocalAddr() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getLocalAddr", "");
        }
        return null;
    }

    public String getLocalName() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getLocalName", "");
        }
        return null;
    }

    public int getLocalPort() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getLocalPort", "");
        }
        return 0;
    }

    public byte[] getSSLSessionID() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSSLSessionID", "");
        }
        return null;
    }

    public String getSessionID() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSessionID", "");
        }
        return null;
    }

    public boolean isProxied() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isProxied", "");
        }
        return false;
    }

    public IResponse getWCCResponse() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getWCCResponse", "");
        }
        return null;
    }

    public String getCipherSuite() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getCipherSuite", "");
        }
        return null;
    }

    public X509Certificate[] getPeerCertificates() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getPeerCertificates", "");
        }
        return null;
    }

    public Cookie[] getCookies() {
        if (this.m_cookies == null || !this.m_cookies.hasParameters()) {
            return null;
        }
        Cookie[] cookies = new Cookie[this.m_cookies.size()];
        Iterator localIter = this.m_cookies.getParameters();
        int i = 0;
        while (localIter != null && localIter.hasNext()) {
            Cookie c;
            String paramName = (String)localIter.next();
            String localParam = this.m_cookies.getParameter(paramName);
            cookies[i] = c = new Cookie(paramName, localParam);
            ++i;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getCookies", "returned " + i + " cookies.");
        }
        return cookies;
    }

    public void setStatusCode(int code) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setStatusCode", "code=" + code);
        }
        this.m_statusCode = code;
    }

    public boolean isCommitted() {
        return false;
    }

    public void addHeader(String name, String value) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addHeader", "name= " + name + ", value= " + value);
        }
    }

    public void addHeader(byte[] name, byte[] value) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addHeader", "name= " + Arrays.toString(name) + ", value= " + Arrays.toString(value));
        }
    }

    public void addDateHeader(String name, long t) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addDateHeader", "name= " + name + ", t= " + t);
        }
    }

    public void addIntHeader(String name, int i) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addIntHeader", "");
        }
    }

    public void setDateHeader(String name, long t) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setDateHeader", "name= " + name + ", t= " + t);
        }
    }

    public void setIntHeader(String name, int i) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setIntHeader", "name= " + name + ", i= " + i);
        }
    }

    public Vector[] getHeaderTable() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getHeaderTable", "");
        }
        return null;
    }

    public String getHeader(byte[] name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getHeader", "name= " + Arrays.toString(name));
        }
        return null;
    }

    public boolean containsHeader(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "containsHeader", "name= " + name);
        }
        return false;
    }

    public boolean containsHeader(byte[] name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "containsHeader", "name= " + Arrays.toString(name));
        }
        return false;
    }

    public void removeHeader(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeHeader", "name= " + name);
        }
    }

    public void removeHeader(byte[] name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeHeader", "name= " + Arrays.toString(name));
        }
    }

    public IRequestExtended getWCCRequest() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getWCCRequest", "");
        }
        return null;
    }

    public void setReason(String reason) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setReason", " reason= " + reason);
        }
    }

    public void setReason(byte[] reason) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setReason", " reason= " + String.valueOf(reason));
        }
    }

    public void addCookie(Cookie cookie) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addCookie", " cookie= " + cookie);
        }
    }

    public void prepareHeadersForWrite() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "prepareHeadersForWrite", "");
        }
        this.prepareForWrite();
    }

    public void writeHeaders() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "writeHeaders", "");
        }
    }

    public void setHeader(String name, String s) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setHeader", "name= " + name + ", s= " + s);
        }
        this._wasResponseHeaders.put(name, s);
    }

    public void setHeader(byte[] name, byte[] bs) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setHeader", "name= " + Arrays.toString(name) + ", bs= " + Arrays.toString(bs));
        }
        this._wasResponseHeaders.put(new String(name, Charset.defaultCharset()), new String(bs, Charset.defaultCharset()));
    }

    public void setContentType(String value) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setContentType", "value= " + value);
        }
    }

    public void setContentType(byte[] value) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setContentType", "value= " + Arrays.toString(value));
        }
    }

    public void setContentLanguage(String value) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setContentLanguage", "value= " + value);
        }
    }

    public void setContentLanguage(byte[] value) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setContentLanguage", "value= " + Arrays.toString(value));
        }
    }

    public SipServletInvokerListener getListener() {
        return this._listener;
    }

    public void setListener(SipServletInvokerListener listener) {
        this._listener = listener;
    }

    public SipServletRequest getRequest() {
        return this._request;
    }

    public SipServletResponse getResponse() {
        return this._response;
    }

    @Override
    public void run() {
        SipServletResponse response;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Dispatching a SipMessage= " + this + " on thread " + Thread.currentThread());
        }
        if (c_logger.isTraceDebugEnabled() && null != (response = this.getResponse())) {
            c_logger.traceEntry(this, "Sipmessage.run() response callId[" + response.getCallId() + "] status[" + response.getStatus() + "]");
        }
        this.dispatch();
    }

    public void dispatch() {
        block10: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "dispatch");
            }
            try {
                SipServletInvokerListener listener;
                SipServletResponse response;
                DynamicVirtualHostManager dhostm;
                DynamicVirtualHost dhost;
                SipServletResponse response2;
                ThreadLocalStorage.setSipMessage(this);
                if (c_logger.isTraceDebugEnabled() && null != (response2 = this.getResponse())) {
                    c_logger.traceEntry(this, "dispatching response callId[" + response2.getCallId() + "] status[" + response2.getStatus() + "] to webcontainer");
                }
                if ((dhost = (dhostm = SipContainerComponent.getVirtualHostMgr()).getVirtualHost(this.m_appDesc.getVirtualHostName(), null)) == null) {
                    int errorCode = PropertiesStore.getInstance().getProperties().getInt("sipNoRouteErrorCode");
                    SipRouter.sendErrorResponse((SipServletRequestImpl)this._request, errorCode);
                    ThreadLocalStorage.setSipMessage(null);
                    return;
                }
                Runnable task = dhost.createRunnableHandler((IRequest)this, (IResponse)this, (HttpInboundConnection)new EmptyHttpInboundConnection());
                task.run();
                if (c_logger.isTraceDebugEnabled() && null != (response = this.getResponse())) {
                    c_logger.traceEntry(this, "dispatch response callId[" + response.getCallId() + "] status[" + response.getStatus() + "] to webcontainer");
                }
                if (null != (listener = this.getListener())) {
                    SipServletRequest request;
                    SipServletResponse response3 = this.getResponse();
                    if (null != response3) {
                        listener.servletInvoked(response3);
                    }
                    if (null != (request = this.getRequest())) {
                        listener.servletInvoked(request);
                    }
                }
                ThreadLocalStorage.setSipMessage(null);
            }
            catch (Throwable e2) {
                if (!c_logger.isErrorEnabled()) break block10;
                Object[] args = new Object[]{this};
                c_logger.error("error.invoking.request", "Request", args, e2);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "dispatch");
        }
    }

    @Override
    public int getQueueIndex() {
        TransactionUserWrapper tu = null;
        tu = this._request != null ? ((SipServletMessageImpl)((Object)this._request)).getTransactionUser() : ((SipServletMessageImpl)((Object)this._response)).getTransactionUser();
        return SipApplicationSessionImpl.extractAppSessionCounter(tu.getApplicationId());
    }

    @Override
    public int priority() {
        if (null != this._response) {
            return 100;
        }
        if (!this._request.isInitial()) {
            return 100;
        }
        return 50;
    }

    public boolean getShouldDestroy() {
        return false;
    }

    public void setShouldDestroy(boolean shouldDestroy) {
    }

    public void setShouldReuse(boolean b) {
    }

    public void setShouldClose(boolean b) {
    }

    public void setAllocateDirect(boolean allocateDirect) {
    }

    public boolean isAllocateDirect() {
        return true;
    }

    public void setLastBuffer(boolean writeLastBuffer) {
    }

    public void releaseChannel() {
    }

    public boolean isStartAsync() {
        return false;
    }

    public void lock() {
    }

    public void startAsync() {
    }

    public void unlock() {
    }

    public ThreadPool getThreadPool() {
        return null;
    }

    @Override
    public Object getServiceSynchronizer() {
        TransactionUserWrapper tu = this._request != null ? ((SipServletMessageImpl)((Object)this._request)).getTransactionUser() : ((SipServletMessageImpl)((Object)this._response)).getTransactionUser();
        return tu.getServiceSynchronizer();
    }

    public void removeCookie(String cookieName) {
        if (this.m_cookies == null || !this.m_cookies.hasParameters()) {
            return;
        }
        this.m_cookies.removeParameter(cookieName);
    }

    @Override
    public TaskDurationMeasurer getSipContainerQueueDuration() {
        return this._sipContainerQueueDuration;
    }

    @Override
    public TaskDurationMeasurer getApplicationCodeDuration() {
        return this._sipContainerApplicationCodeDuration;
    }

    @Override
    public String getAppName() {
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        return 0;
    }

    @Override
    public void setSipContainerQueueDuration(TaskDurationMeasurer tm) {
        this._sipContainerQueueDuration = tm;
    }

    @Override
    public void setApplicationCodeDuration(TaskDurationMeasurer tm) {
        this._sipContainerApplicationCodeDuration = tm;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this.m_message.getApplicationSession(false);
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this._request != null) {
            return ((SipServletMessageImpl)((Object)this._request)).getTransactionUser();
        }
        return ((SipServletMessageImpl)((Object)this._response)).getTransactionUser();
    }

    public void setIsClosing(boolean isClosing) {
    }

    public void setContentLength(int length) {
    }

    public void resetBuffer() {
    }

    public int getBufferSize() {
        return 0;
    }

    public void setBufferSize(int bufferSize) {
    }

    public void flushBuffer() throws IOException {
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public HttpInboundConnection getHttpInboundConnection() {
        return null;
    }

    public Socket getRequestSocket() {
        return null;
    }
}

