/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.rules;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.rules.Operator;
import com.ibm.ws.sip.container.rules.PhoneComparison;

public class Contains
extends Operator {
    private static final LogMgr c_logger = Log.get(Contains.class);
    private String m_value;
    private boolean m_ignoreCase;

    public Contains(String var, String value, boolean ignoreCase) {
        super(var);
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{var, value, new Boolean(ignoreCase)};
            c_logger.traceEntry((Object)this, "Contains", params);
        }
        this.m_value = value;
        this.m_ignoreCase = ignoreCase;
    }

    @Override
    protected boolean evaluate(String value) {
        String string1 = value;
        String string2 = this.m_value;
        if (this.m_ignoreCase) {
            string1 = string1.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return string1.indexOf(string2) > -1;
    }

    @Override
    protected boolean evaluate(PhoneComparison value) {
        return value.contains(this.m_value, this.m_ignoreCase);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(16);
        buffer.append(this.getVariable());
        buffer.append(" CONTAINS '");
        buffer.append(this.m_value);
        buffer.append("'");
        return buffer.toString();
    }
}

