/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcSessionsStore {
    private final Map<String, List<OidcSessionInfo>> sidToSessionsMap = new HashMap<String, List<OidcSessionInfo>>();
    static final long serialVersionUID = -5007095948056968091L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean insertSession(String sid, OidcSessionInfo oidcSessionInfo) {
        if (!this.sidToSessionsMap.containsKey(sid)) {
            this.sidToSessionsMap.put(sid, new ArrayList());
        }
        List<OidcSessionInfo> sessions = this.sidToSessionsMap.get(sid);
        if (sid != null && !sid.isEmpty() && !sessions.isEmpty()) {
            return false;
        }
        return sessions.add(oidcSessionInfo);
    }

    public OidcSessionInfo getSession(String sid) {
        if (sid == null || sid.isEmpty()) {
            return null;
        }
        if (!this.sidToSessionsMap.containsKey(sid)) {
            return null;
        }
        return this.sidToSessionsMap.get(sid).get(0);
    }

    public List<OidcSessionInfo> getSessions() {
        ArrayList<OidcSessionInfo> sessions = new ArrayList<OidcSessionInfo>();
        for (String key : this.sidToSessionsMap.keySet()) {
            sessions.addAll((Collection<OidcSessionInfo>)this.sidToSessionsMap.get(key));
        }
        return sessions;
    }

    public boolean removeSession(String sid) {
        if (sid != null && !sid.isEmpty()) {
            List<OidcSessionInfo> removedSession = this.sidToSessionsMap.remove(sid);
            return removedSession != null;
        }
        return false;
    }

    public OidcSessionInfo removeSessionBySessionId(String oidcSessionId) {
        for (String key : this.sidToSessionsMap.keySet()) {
            List<OidcSessionInfo> oidcSessions = this.sidToSessionsMap.get(key);
            for (int i = 0; i < oidcSessions.size(); ++i) {
                OidcSessionInfo oidcSessionInfo = oidcSessions.get(i);
                if (!oidcSessionInfo.getSessionId().equals(oidcSessionId)) continue;
                oidcSessions.remove(i);
                if (oidcSessions.isEmpty()) {
                    this.sidToSessionsMap.remove(key);
                }
                return oidcSessionInfo;
            }
        }
        return null;
    }

    public boolean removeSessions() {
        if (this.sidToSessionsMap.keySet().isEmpty()) {
            return false;
        }
        this.sidToSessionsMap.clear();
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.clients.common.OidcSessionsStore", OidcSessionsStore.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    }
}

