/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.caller;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.wssecurity.caller.AssertionToSubject;
import com.ibm.ws.wssecurity.caller.SamlCallerTokenException;
import com.ibm.ws.wssecurity.token.TokenUtils;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SAMLAuthenticator {
    public static final TraceComponent tc = Tr.register(SAMLAuthenticator.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    WebProviderAuthenticatorHelper authHelper;
    private Map<String, Object> callerConfig = null;
    private Saml20Token samltoken = null;
    static final long serialVersionUID = 154840321663826637L;

    public SAMLAuthenticator(Map<String, Object> callerConfig, Saml20Token token) {
        this.callerConfig = callerConfig;
        this.samltoken = token;
        this.authHelper = TokenUtils.getAuthHelper();
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationResult authenticate() throws Exception {
        try {
            Saml20Token saml20Token = this.samltoken;
            AssertionToSubject mapAssertToSubjectUtil = new AssertionToSubject(this.callerConfig, saml20Token);
            String user = mapAssertToSubjectUtil.getUser();
            Hashtable<String, Object> hashtable = this.createHashtable(mapAssertToSubjectUtil, saml20Token, user);
            AuthenticationResult result = this.authenticateLogin(hashtable, user);
            if (result.getStatus() != AuthResult.SUCCESS) {
                if ("User".equalsIgnoreCase((String)this.callerConfig.get("mapToUserRegistry"))) {
                    Tr.error((TraceComponent)tc, (String)"error_authenticate_maptouser", (Object[])new Object[]{user});
                } else {
                    Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{result.getReason()});
                }
            }
            return result;
        }
        catch (SamlCallerTokenException saml20Token) {
            void e;
            FFDCFilter.processException((Throwable)saml20Token, (String)"com.ibm.ws.wssecurity.caller.SAMLAuthenticator", (String)"83", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + e.getCause()), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"failed_to_obtain_subject_info", (Object[])new Object[]{e.getLocalizedMessage()});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wssecurity.caller.SAMLAuthenticator", (String)"93", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + e.getCause()), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"failed_to_authenticate", (Object[])new Object[]{e.getLocalizedMessage()});
            throw e;
        }
    }

    private AuthenticationResult authenticateLogin(Hashtable<String, Object> hashtable, String user) {
        Subject subject = new Subject();
        if (((Boolean)this.callerConfig.get("includeTokenInSubject")).booleanValue()) {
            subject.getPrivateCredentials().add(this.samltoken);
        }
        AuthenticationResult authResult = null;
        boolean isUserMapToUR = false;
        if ("User".equalsIgnoreCase((String)this.callerConfig.get("mapToUserRegistry"))) {
            isUserMapToUR = true;
        }
        authResult = this.authHelper.loginWithUserName(null, null, user, subject, hashtable, isUserMapToUR);
        return authResult;
    }

    Hashtable<String, Object> createHashtable(AssertionToSubject mapAssertToSubject, Saml20Token saml20Token, String user) throws SamlCallerTokenException, WSSecurityException, RemoteException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String realm = null;
        String uniqueID = null;
        List<String> groups = null;
        if ("No".equalsIgnoreCase((String)this.callerConfig.get("mapToUserRegistry"))) {
            realm = mapAssertToSubject.getRealm();
            uniqueID = mapAssertToSubject.getUserUniqueIdentity(user, realm);
            groups = mapAssertToSubject.getGroupUniqueIdentity(realm);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.uniqueId", uniqueID);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.securityName", user);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.realm", realm);
            if (!groups.isEmpty()) {
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.groups", groups);
            }
        } else if ("User".equalsIgnoreCase((String)this.callerConfig.get("mapToUserRegistry"))) {
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.userId", user);
        } else if ("Group".equalsIgnoreCase((String)this.callerConfig.get("mapToUserRegistry"))) {
            realm = mapAssertToSubject.getRealm();
            uniqueID = mapAssertToSubject.getUserUniqueIdentity(user, realm);
            groups = mapAssertToSubject.getGroupUniqueIdentityFromRegistry(realm);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.uniqueId", uniqueID);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.securityName", user);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.realm", realm);
            if (!groups.isEmpty()) {
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.groups", groups);
            }
        }
        this.putValue(hashtable, "com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        if (((Boolean)this.callerConfig.get("allowCustomCacheKey")).booleanValue()) {
            String cache_key = mapAssertToSubject.getCustomCacheKeyValue();
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.cacheKey", cache_key);
        }
        return hashtable;
    }

    void putValue(Hashtable<String, Object> hashtable, String key, Object value) {
        if (value == null) {
            return;
        }
        hashtable.put(key, value);
    }
}

