/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.CryptoCoverageUtil;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CryptoCoverageChecker
extends AbstractSoapInterceptor {
    protected List<XPathExpression> xPaths = new ArrayList<XPathExpression>();
    protected Map<String, String> prefixMap = new HashMap<String, String>();
    private boolean checkFaults = true;

    public CryptoCoverageChecker() {
        this(null, null);
    }

    public CryptoCoverageChecker(Map<String, String> prefixes, List<XPathExpression> xPaths) {
        super("pre-protocol");
        this.addAfter(WSS4JInInterceptor.class.getName());
        this.setPrefixes(prefixes);
        this.setXPaths(xPaths);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Element documentElement;
        if (this.xPaths != null) {
            this.xPaths.isEmpty();
        }
        if (message.getContent(SOAPMessage.class) == null) {
            throw new SoapFault("Error obtaining SOAP document", Fault.FAULT_CODE_CLIENT);
        }
        try {
            SOAPMessage saajDoc = (SOAPMessage)message.getContent(SOAPMessage.class);
            SOAPEnvelope envelope = saajDoc.getSOAPPart().getEnvelope();
            if (!this.checkFaults && envelope.getBody().hasFault()) {
                return;
            }
            documentElement = (Element)DOMUtils.getDomElement((Node)envelope);
        }
        catch (SOAPException e) {
            throw new SoapFault("Error obtaining SOAP document", Fault.FAULT_CODE_CLIENT);
        }
        HashSet<WSDataRef> signed = new HashSet<WSDataRef>();
        HashSet<WSDataRef> encrypted = new HashSet<WSDataRef>();
        List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
        if (results != null) {
            for (WSHandlerResult wshr : results) {
                List encryptedResults;
                List signedResults = (List)wshr.getActionResults().get(2);
                if (signedResults != null) {
                    for (WSSecurityEngineResult signedResult : signedResults) {
                        List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
                        if (sl == null || sl.size() == 1 && ((WSDataRef)sl.get(0)).getName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"))) continue;
                        signed.addAll(sl);
                    }
                }
                if ((encryptedResults = (List)wshr.getActionResults().get(4)) == null) continue;
                for (WSSecurityEngineResult encryptedResult : encryptedResults) {
                    List el = CastUtils.cast((List)((List)encryptedResult.get((Object)"data-ref-uris")));
                    if (el == null) continue;
                    encrypted.addAll(el);
                }
            }
        }
        CryptoCoverageUtil.reconcileEncryptedSignedRefs(signed, encrypted);
        XPathFactory factory = XPathFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            // empty catch block
        }
        XPath xpath = factory.newXPath();
        if (this.prefixMap != null) {
            xpath.setNamespaceContext((NamespaceContext)new MapNamespaceContext(this.prefixMap));
        }
        for (XPathExpression xPathExpression : this.xPaths) {
            HashSet<WSDataRef> refsToCheck = null;
            switch (xPathExpression.getType()) {
                case SIGNED: {
                    refsToCheck = signed;
                    break;
                }
                case ENCRYPTED: {
                    refsToCheck = encrypted;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected crypto type: " + (Object)((Object)xPathExpression.getType()));
                }
            }
            try {
                CryptoCoverageUtil.checkCoverage(documentElement, refsToCheck, xpath, Arrays.asList(xPathExpression.getXPath()), xPathExpression.getType(), xPathExpression.getScope());
            }
            catch (WSSecurityException e) {
                throw new SoapFault("No " + (Object)((Object)xPathExpression.getType()) + " element found matching XPath " + xPathExpression.getXPath(), Fault.FAULT_CODE_CLIENT);
            }
        }
    }

    public final void setXPaths(List<XPathExpression> xpaths) {
        this.xPaths.clear();
        if (xpaths != null) {
            this.xPaths.addAll(xpaths);
        }
    }

    public final void addXPaths(List<XPathExpression> xpaths) {
        if (xpaths != null) {
            this.xPaths.addAll(xpaths);
        }
    }

    public final void setPrefixes(Map<String, String> prefixes) {
        this.prefixMap.clear();
        if (prefixes != null) {
            this.prefixMap.putAll(prefixes);
        }
    }

    public final void addPrefixes(Map<String, String> prefixes) {
        if (prefixes != null) {
            this.prefixMap.putAll(prefixes);
        }
    }

    public boolean isCheckFaults() {
        return this.checkFaults;
    }

    public void setCheckFaults(boolean checkFaults) {
        this.checkFaults = checkFaults;
    }

    public static class XPathExpression {
        private final String xPath;
        private final CryptoCoverageUtil.CoverageType type;
        private final CryptoCoverageUtil.CoverageScope scope;

        public XPathExpression(String xPath, CryptoCoverageUtil.CoverageType type) {
            this(xPath, type, CryptoCoverageUtil.CoverageScope.ELEMENT);
        }

        public XPathExpression(String xPath, CryptoCoverageUtil.CoverageType type, CryptoCoverageUtil.CoverageScope scope) {
            if (xPath == null) {
                throw new NullPointerException("xPath cannot be null.");
            }
            if (type == null) {
                throw new NullPointerException("type cannot be null.");
            }
            this.xPath = xPath;
            this.type = type;
            this.scope = scope;
        }

        public String getXPath() {
            return this.xPath;
        }

        public CryptoCoverageUtil.CoverageType getType() {
            return this.type;
        }

        public CryptoCoverageUtil.CoverageScope getScope() {
            return this.scope;
        }

        public boolean equals(Object xpathObject) {
            if (!(xpathObject instanceof XPathExpression)) {
                return false;
            }
            if (xpathObject == this) {
                return true;
            }
            XPathExpression xpath = (XPathExpression)xpathObject;
            if (xpath.getScope() != this.getScope()) {
                return false;
            }
            if (xpath.getType() != this.getType()) {
                return false;
            }
            if (this.getXPath() == null && xpath.getXPath() != null) {
                return false;
            }
            return this.getXPath() == null || this.getXPath().equals(xpath.getXPath());
        }

        public int hashCode() {
            int result = 17;
            if (this.getXPath() != null) {
                result = 31 * result + this.getXPath().hashCode();
            }
            if (this.getType() != null) {
                result = 31 * result + this.getType().hashCode();
            }
            if (this.getScope() != null) {
                result = 31 * result + this.getScope().hashCode();
            }
            return result;
        }
    }
}

