/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.async.listener;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.ws.webcontainer31.async.AsyncWriteCallback;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.wsspi.http.ee7.HttpOutputStreamEE7;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import java.io.IOException;
import javax.servlet.WriteListener;

public class WriteListenerRunnable
implements Runnable {
    private static final TraceComponent tc = Tr.register(WriteListenerRunnable.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private WriteListener _listener = null;
    private ThreadContextManager _tcm = null;
    private HttpOutputStreamEE7 _hout = null;
    private AsyncWriteCallback _cb = null;
    private SRTServletRequestThreadData _requestDataWriteListenerThread;

    public WriteListenerRunnable(WriteListener listener, HttpOutputStreamEE7 hout, AsyncWriteCallback callback, ThreadContextManager tcm) {
        this._listener = listener;
        this._tcm = tcm;
        this._hout = hout;
        this._cb = callback;
        this._requestDataWriteListenerThread = SRTServletRequestThreadData.getInstance();
    }

    public WriteListenerRunnable(WriteListener listener, ThreadContextManager tcm) {
        this._listener = listener;
        this._tcm = tcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={IOException.class})
    public void run() {
        WebContainerRequestState reqState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Run WriteListenerRunnable start, WriteListener enabled: " + this._listener + " , current thread -->" + Thread.currentThread().getName() + " , outputStream [" + this._hout + "] , AsyncWriteCallBack [" + this._cb + "]"), (Object[])new Object[0]);
        }
        if ((reqState = WebContainerRequestState.getInstance((boolean)false)) != null) {
            reqState.init();
        }
        SRTServletRequestThreadData.getInstance().init(this._requestDataWriteListenerThread);
        this._tcm.pushContextData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Invoking the onWritePossible first time , " + this._listener), (Object[])new Object[0]);
        }
        WebContainerRequestState.getInstance((boolean)true).setAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread", (Object)true);
        if (this._hout != null) {
            HttpOutputStreamEE7 httpOutputStreamEE7 = this._hout;
            synchronized (httpOutputStreamEE7) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ENTER listener onWritePossible , " + this._listener), (Object[])new Object[0]);
                    }
                    this._listener.onWritePossible();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RETURN from listener onWritePossible , " + this._listener), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("An exception occurred during the onWritePossible : " + e), (Object[])new Object[0]);
                    }
                    this._hout.setExceptionDuringOnWP(true);
                    this._cb.error(this._hout.getVc(), e);
                }
                finally {
                    this._tcm.popContextData();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("Run WriteListenerRunnable done for [" + this._listener + "]"));
                    }
                }
            }
        }
        try {
            this._listener.onWritePossible();
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An exception occurred during the onWritePossible for [" + this._listener + ". Exception: " + ioe), (Object[])new Object[0]);
            }
            this._listener.onError((Throwable)ioe);
        }
        finally {
            this._tcm.popContextData();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("Run WriteListenerRunnable done for [" + this._listener + "]"));
            }
        }
    }
}

