/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.common.utils.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String SHA256 = "SHA-256";
    private static final String MD5 = "MD5";

    public static String getFileMD5String(File file) throws IOException {
        MessageDigest messageDigest = HashUtils.getMessageDigest(MD5);
        return HashUtils.getFileHashString(file, messageDigest);
    }

    public static String getFileSHA256String(File file) throws IOException {
        MessageDigest messageDigest = HashUtils.getMessageDigest(SHA256);
        return HashUtils.getFileHashString(file, messageDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileHashString(File file, MessageDigest messagedigest) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                messagedigest.update(buffer, 0, numRead);
            }
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception exception) {}
            }
        }
        return HashUtils.byteArrayToHexString(messagedigest.digest());
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer stringbuffer = new StringBuffer(2 * byteArray.length);
        for (int i = 0; i < byteArray.length; ++i) {
            char upper = hexDigits[(byteArray[i] & 0xF0) >> 4];
            char lower = hexDigits[byteArray[i] & 0xF];
            stringbuffer.append(upper);
            stringbuffer.append(lower);
        }
        return stringbuffer.toString();
    }

    private static MessageDigest getMessageDigest(String digestType) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(digestType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return messageDigest;
    }
}

