/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.internal.OAuth20AuthenticatorImpl;
import com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Authenticator;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuth20ServiceImpl
implements OAuth20Service {
    public static final TraceComponent tc = Tr.register(OAuth20ServiceImpl.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    OAuth20Authenticator authenticator = new OAuth20AuthenticatorImpl();
    protected static final Pattern OAUTH_PROTECTED_PATTERN = Pattern.compile("/([\\w-]+)/(authorize|registration)");
    protected static final Pattern OAUTH_SPECIFIC_PATTERN = Pattern.compile("/([\\w-]+)/.*");
    protected static final String KEY_ID = "id";
    protected static final String KEY_oauth20Provider = "oauth20Provider";
    protected static final ConcurrentServiceReferenceMap<String, OAuth20Provider> oauth20ProviderRef = new ConcurrentServiceReferenceMap("oauth20Provider");
    static final long serialVersionUID = 120847336188833968L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOauth20Provider(ServiceReference<OAuth20Provider> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setOAuth20Provider id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedOauth20Provider(ServiceReference<OAuth20Provider> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateOAuth20Provider id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetOauth20Provider(ServiceReference<OAuth20Provider> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.removeReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetOAuth20Provider id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void activate(ComponentContext cc) {
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.activate(cc);
        }
    }

    protected synchronized void modify(Map<String, Object> properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deactivate(ComponentContext cc) {
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.deactivate(cc);
        }
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res) {
        ProviderAuthenticationResult result = this.authenticator.authenticate(req, res);
        this.handleOauthChallenge(res, result);
        return result;
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, ConcurrentServiceReferenceMap<String, OidcServerConfig> oidcServerConfigRef) {
        ProviderAuthenticationResult result = this.authenticator.authenticate(req, res);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOauthSpecificURI(HttpServletRequest req, boolean protectedOrAll) {
        String oauthProviderName;
        OAuth20Provider oauthServerConfig;
        Matcher matcher;
        boolean isOauthSpecific = false;
        String contextPath = req.getContextPath();
        String uri = req.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("contextPath=" + contextPath + " uri=" + uri), (Object[])new Object[0]);
        }
        if (contextPath != null && contextPath.equals("/oauth2") && (matcher = this.endpointRequest(req)) != null && (oauthServerConfig = this.getOAuth20Provider(oauthProviderName = this.getProviderNameFromUrl(matcher))) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("check " + (protectedOrAll ? "Protected-Endpoints" : "All-endpoints")), (Object[])new Object[0]);
            }
            if (!protectedOrAll) {
                return true;
            }
            if (this.protectedEndpointRequest(req) != null) {
                return true;
            }
        }
        if (!isOauthSpecific && !protectedOrAll) {
            ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
            synchronized (concurrentServiceReferenceMap) {
                Iterator oauth20Providers = oauth20ProviderRef.getServices();
                while (oauth20Providers.hasNext()) {
                    OAuth20Provider provider = (OAuth20Provider)oauth20Providers.next();
                    if (!provider.isMiscUri(req)) continue;
                    return true;
                }
            }
        }
        return isOauthSpecific;
    }

    private Matcher endpointRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("path=" + path), (Object[])new Object[0]);
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        Matcher m = OAUTH_SPECIFIC_PATTERN.matcher(path);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private Matcher protectedEndpointRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("path=" + path), (Object[])new Object[0]);
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        Matcher m = OAUTH_PROTECTED_PATTERN.matcher(path);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    protected String getProviderNameFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuth20Provider getOAuth20Provider(String oauth20ProviderId) {
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            return (OAuth20Provider)oauth20ProviderRef.getService((Object)oauth20ProviderId);
        }
    }

    void handleOauthChallenge(HttpServletResponse rsp, ProviderAuthenticationResult oauthResult) {
        String errorDescription = null;
        if (oauthResult.getStatus() == AuthResult.FAILURE) {
            if (401 == oauthResult.getHttpStatusCode()) {
                errorDescription = "OAuth service failed the request";
            }
        } else if (oauthResult.getStatus() != AuthResult.SUCCESS && 401 == oauthResult.getHttpStatusCode()) {
            errorDescription = "OAuth service failed the request due to unsuccessful request";
        }
        if (errorDescription != null) {
            try {
                OAuth20ProviderUtils.handleOAuthChallenge(rsp, oauthResult, errorDescription);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.internal.OAuth20ServiceImpl", (String)"225", (Object)this, (Object[])new Object[]{rsp, oauthResult});
            }
        }
    }
}

