/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api;

import com.ibm.oauth.core.api.OAuthComponentInstance;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.internal.OAuthComponentInstanceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OAuthComponentFactory {
    static final String CLASS = OAuthComponentFactory.class.getName();
    static Logger _log = Logger.getLogger(CLASS);
    static Map<String, OAuthComponentInstance> _instances = new HashMap<String, OAuthComponentInstance>();

    public static synchronized OAuthComponentInstance getOAuthComponentInstance(OAuthComponentConfiguration config) throws OAuthException {
        OAuthComponentInstance result = null;
        String methodName = "getOAuthComponentInstance";
        _log.entering(CLASS, methodName);
        try {
            result = _instances.get(config.getUniqueId());
            if (result == null) {
                result = new OAuthComponentInstanceImpl(config);
                _instances.put(config.getUniqueId(), result);
            }
        }
        finally {
            _log.exiting(CLASS, methodName, result);
        }
        return result;
    }

    public static synchronized OAuthComponentInstance reloadOAuthComponentInstance(OAuthComponentConfiguration config) throws OAuthException {
        OAuthComponentInstance result = null;
        String methodName = "reloadOAuthComponentInstance";
        _log.entering(CLASS, methodName);
        try {
            _instances.remove(config.getUniqueId());
            result = OAuthComponentFactory.getOAuthComponentInstance(config);
            _log.exiting(CLASS, methodName, result);
        }
        catch (Throwable throwable) {
            _log.exiting(CLASS, methodName, result);
            throw throwable;
        }
        return result;
    }
}

