/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.google.gson.JsonArray;
import com.ibm.json.java.JSONObject;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.exception.OAuth20BadParameterException;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuth20ProviderUtils {
    private static TraceComponent tc = Tr.register(OAuth20ProviderUtils.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    protected static String OAuthConfigFileDir = null;
    public static final String AUTHENTICATE_HDR = "WWW-Authenticate";
    static final long serialVersionUID = -4998153886747493417L;

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static Object processClass(String className, String configConstant, Class<?> interfaceName, ClassLoader classloader) throws OAuthException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processClass", (Object[])new Object[]{className, configConstant, interfaceName, classloader});
        }
        if (className == null) {
            throw new OAuthConfigurationException("security.oauth.error.config.notspecified.exception", configConstant, "null", null);
        }
        try {
            Class<?> klass = classloader.loadClass(className);
            Object ret = klass.newInstance();
            if (!interfaceName.isAssignableFrom(ret.getClass())) {
                throw new OAuthConfigurationException("security.oauth.error.classmismatch.exception", configConstant, interfaceName.getName(), null);
            }
            Object obj = ret;
            return obj;
        }
        catch (ClassNotFoundException klass) {
            void e;
            FFDCFilter.processException((Throwable)klass, (String)"com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils", (String)"69", null, (Object[])new Object[]{className, configConstant, interfaceName, classloader});
            throw new OAuthConfigurationException("security.oauth.error.classinstantiation.exception", configConstant, className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils", (String)"71", null, (Object[])new Object[]{className, configConstant, interfaceName, classloader});
            throw new OAuthConfigurationException("security.oauth.error.classinstantiation.exception", configConstant, className, e);
        }
        catch (InstantiationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils", (String)"73", null, (Object[])new Object[]{className, configConstant, interfaceName, classloader});
            throw new OAuthConfigurationException("security.oauth.error.classinstantiation.exception", configConstant, className, e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processClass");
            }
        }
    }

    public static OidcBaseClient getOidcOAuth20Client(OAuth20Provider provider, String clientId) throws OAuth20Exception {
        if (provider == null) {
            return null;
        }
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        if (clientProvider != null) {
            return clientProvider.get(clientId);
        }
        return null;
    }

    public static void validateResource(HttpServletRequest request, AttributeList attrList, OidcBaseClient client) throws OAuth20BadParameterException {
        String[] resourceParams = request.getParameterValues("resource");
        if (resourceParams == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The resource parameter was not found", (Object[])new Object[0]);
            }
            return;
        }
        JsonArray authorizedResourceids = client.getResourceIds();
        HashSet<String> resourceSet = new HashSet<String>();
        int iResources = resourceParams.length;
        for (int j = 0; j < iResources; ++j) {
            String resourceStr = resourceParams[0];
            String[] resources = resourceStr.split(" ");
            for (int i = 0; i < resources.length; ++i) {
                String resource = resources[i].trim();
                if (resource == null || resource.length() <= 0) continue;
                if (OidcOAuth20Util.jsonArrayContainsString(authorizedResourceids, resource)) {
                    resourceSet.add(resource);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("The requested resource [" + resource + "] is authorized."), (Object[])new Object[0]);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The requested resource [" + resource + "] is not authorized."), (Object[])new Object[0]);
                }
                throw new OAuth20BadParameterException("SECURITY.OAUTH20.ERROR.VALUE.NOT.IN.LIST", new Object[]{"resource", resource, OidcOAuth20Util.getSpaceDelimitedString(authorizedResourceids), "resourceIds"});
            }
        }
        String[] validResources = resourceSet.toArray(new String[resourceSet.size()]);
        if (validResources != null && validResources.length > 0) {
            if (attrList != null) {
                attrList.setAttribute("resource", "urn:ibm:names:oauth:param", validResources);
            }
            request.setAttribute("urn:ibm:names:authn:param:resource", (Object)validResources);
        }
    }

    public static void handleOAuthChallenge(HttpServletResponse rsp, ProviderAuthenticationResult oauthResult, String errorDescription) throws IOException {
        if (rsp.isCommitted()) {
            return;
        }
        String error = "error";
        String error_description = "error_description";
        int errorCode = 401;
        rsp.setStatus(401);
        String wwwAuthenticate = rsp.getHeader(AUTHENTICATE_HDR);
        if (wwwAuthenticate == null || wwwAuthenticate.isEmpty()) {
            wwwAuthenticate = "Bearer realm=\"oauth\"";
            rsp.setHeader(AUTHENTICATE_HDR, wwwAuthenticate);
        }
        rsp.setHeader("Content-Type", "application/json;charset=UTF-8");
        JSONObject responseJSON = new JSONObject();
        responseJSON.put((Object)"error", (Object)401);
        if (errorDescription != null) {
            responseJSON.put((Object)"error_description", (Object)errorDescription);
        }
        PrintWriter pw = rsp.getWriter();
        pw.write(responseJSON.toString());
        pw.flush();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WWW-Authenticate:'" + wwwAuthenticate + "' code:" + 401 + " reason:" + errorDescription), (Object[])new Object[0]);
        }
    }
}

