/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidRedirectUriException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidRedirectUriException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private static final String END_USER_MSG_KEY = "security.oauth20.error.invalid.redirecturi.enduser";
    private String _redirectURI;
    private String _registeredRedirectURI;

    public OAuth20InvalidRedirectUriException(String redirectURI, Throwable cause) {
        super("invalid_request", "The redirect URI parameter was invalid: " + redirectURI, cause);
        this._redirectURI = redirectURI;
    }

    public OAuth20InvalidRedirectUriException(String msgKey, String redirectURI, Throwable cause) {
        this(msgKey, redirectURI, null, cause);
    }

    public OAuth20InvalidRedirectUriException(String msgKey, String redirectUri, String registeredRedirectUri, Throwable cause) {
        super("invalid_request", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{redirectUri, registeredRedirectUri}), cause);
        this._registeredRedirectURI = registeredRedirectUri;
        this._redirectURI = redirectUri;
        this._msgKey = msgKey;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(END_USER_MSG_KEY), null);
    }

    public String getRedirectURI() {
        return this._redirectURI;
    }

    public String getRegisteredRedirectURI() {
        return this._registeredRedirectURI;
    }
}

