/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class AlgorithmPolicyParameters {
    @Nonnull
    @NonnullElements
    private Collection<String> includedAlgorithmURIs = Collections.emptySet();
    @Nonnull
    @NonnullElements
    private Collection<String> excludedAlgorithmURIs = Collections.emptySet();

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> getIncludedAlgorithms() {
        return this.includedAlgorithmURIs;
    }

    public void setIncludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.includedAlgorithmURIs = Collections.emptySet();
            return;
        }
        this.includedAlgorithmURIs = Collections.unmodifiableSet(new HashSet(StringSupport.normalizeStringCollection(uris)));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> getExcludedAlgorithms() {
        return this.excludedAlgorithmURIs;
    }

    public void setExcludedAlgorithms(@Nonnull @NonnullElements Collection<String> uris) {
        if (uris == null) {
            this.excludedAlgorithmURIs = Collections.emptySet();
            return;
        }
        this.excludedAlgorithmURIs = Collections.unmodifiableSet(new HashSet(StringSupport.normalizeStringCollection(uris)));
    }
}

