/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.criterion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.Criterion;

public final class BindingCriterion
implements Criterion {
    @Nonnull
    @NonnullElements
    private final List<String> bindings;

    public BindingCriterion(@Nonnull @NonnullElements List<String> bindingURIs) {
        this.bindings = Collections.unmodifiableList(new ArrayList(StringSupport.normalizeStringCollection(bindingURIs)));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getBindings() {
        return this.bindings;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BindingCriterion [bindings=");
        builder.append(this.bindings);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.bindings.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BindingCriterion) {
            return this.bindings.equals(((BindingCriterion)obj).bindings);
        }
        return false;
    }
}

