/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.CpuMethods;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class ExperimentalCpu {
    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return ExperimentalCpu.registerObservers(openTelemetry, ManagementFactory.getOperatingSystemMXBean(), CpuMethods.systemCpuUtilization());
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, OperatingSystemMXBean osBean, @Nullable Supplier<Double> systemCpuUtilization) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        observables.add(meter.gaugeBuilder("jvm.system.cpu.load_1m").setDescription("Average CPU load of the whole system for the last minute as reported by the JVM.").setUnit("{run_queue_item}").buildWithCallback(observableMeasurement -> {
            double loadAverage = osBean.getSystemLoadAverage();
            if (loadAverage >= 0.0) {
                observableMeasurement.record(loadAverage);
            }
        }));
        if (systemCpuUtilization != null) {
            observables.add(meter.gaugeBuilder("jvm.system.cpu.utilization").setDescription("Recent CPU utilization for the whole system as reported by the JVM.").setUnit("1").buildWithCallback(observableMeasurement -> {
                Double cpuUsage = (Double)systemCpuUtilization.get();
                if (cpuUsage != null && cpuUsage >= 0.0) {
                    observableMeasurement.record(cpuUsage);
                }
            }));
        }
        return observables;
    }

    private ExperimentalCpu() {
    }
}

