/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.state.ModuleStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="io.openliberty.grpc.internal.GrpcManagedObjectProvider", immediate=true, property={"service.vendor=IBM"})
public class GrpcManagedObjectProvider
implements ModuleStateListener {
    private static final TraceComponent tc = Tr.register(GrpcManagedObjectProvider.class);
    private static final AtomicServiceReference<ManagedObjectService> managedObjectServiceSRRef = new AtomicServiceReference("managedObjectService");
    private static final Map<String, Map<Class<?>, ManagedObjectFactory<?>>> managedObjectFactoryCache = new ConcurrentHashMap();

    @Reference(name="managedObjectService", service=ManagedObjectService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        managedObjectServiceSRRef.setReference(ref);
    }

    protected void unsetManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        managedObjectServiceSRRef.unsetReference(ref);
    }

    public void activate(ComponentContext context, Map<String, Object> properties) {
        managedObjectServiceSRRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        managedObjectServiceSRRef.deactivate(context);
    }

    public static ManagedObject<?> createManagedObject(Class<?> clazz) throws ManagedObjectException {
        ManagedObject mo = null;
        ManagedObjectFactory<?> mof = GrpcManagedObjectProvider.getManagedObjectFactory(clazz);
        if (mof != null) {
            mo = mof.createManagedObject();
        }
        return mo;
    }

    public static Object createObjectFromClassName(String className) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ManagedObjectException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName(className, true, cl);
        return GrpcManagedObjectProvider.createObjectFromClass(clazz);
    }

    public static Object createObjectFromClass(Class<?> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ManagedObjectException {
        ManagedObject<?> mo = GrpcManagedObjectProvider.createManagedObject(clazz);
        Object returnObj = null;
        if (mo != null) {
            returnObj = mo.getObject();
        }
        if (returnObj == null) {
            returnObj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return returnObj;
    }

    private static ManagedObjectFactory<?> getManagedObjectFactory(Class<?> clazz) {
        ManagedObjectFactory mof;
        block7: {
            mof = null;
            try {
                ModuleMetaData mmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData();
                Map<Class<?>, ManagedObjectFactory<?>> cache = managedObjectFactoryCache.get(mmd.getName());
                if (cache != null) {
                    mof = cache.get(clazz);
                } else {
                    managedObjectFactoryCache.putIfAbsent(mmd.getName(), new ConcurrentHashMap());
                    cache = managedObjectFactoryCache.get(mmd.getName());
                }
                if (mof != null) {
                    return mof;
                }
                ManagedObjectService mos = (ManagedObjectService)managedObjectServiceSRRef.getServiceWithException();
                if (mos == null) {
                    return null;
                }
                mof = mos.createManagedObjectFactory(mmd, clazz, true);
                cache.put(clazz, mof);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Successfully created ManagedObjectFactory for class: " + clazz.getName()), (Object[])new Object[0]);
                }
            }
            catch (ManagedObjectException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("Failed to create ManagedObjectFactory for class: " + clazz.getName() + " Exception is: " + e.toString()), (Object[])new Object[0]);
            }
        }
        return mof;
    }

    public void moduleStarting(ModuleInfo moduleInfo) throws StateChangeException {
    }

    public void moduleStarted(ModuleInfo moduleInfo) throws StateChangeException {
    }

    public void moduleStopping(ModuleInfo moduleInfo) {
        managedObjectFactoryCache.remove(moduleInfo.getApplicationInfo().getName());
    }

    public void moduleStopped(ModuleInfo moduleInfo) {
    }
}

