/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import io.netty.handler.codec.http.HttpHeaders;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NettyHeader
implements HeaderField {
    HttpHeaders nettyHeaders;
    String name;
    String value;
    HeaderKeys key;
    static final long serialVersionUID = -1542810982825594449L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public NettyHeader(String name, HttpHeaders nettyHeaders) {
        Objects.nonNull(name);
        this.name = name;
        Objects.nonNull(nettyHeaders);
        this.nettyHeaders = nettyHeaders;
        this.key = HttpHeaderKeys.find(name, Boolean.TRUE);
    }

    public NettyHeader(HeaderKeys key, HttpHeaders headers) {
        Objects.nonNull(key);
        this.key = key;
        this.name = key.getName();
        Objects.nonNull(headers);
        this.nettyHeaders = headers;
    }

    public NettyHeader(String name, String value) {
        Objects.nonNull(name);
        this.name = name;
        this.value = Objects.isNull(value) ? "" : value;
        this.key = HttpHeaderKeys.find(name, Boolean.TRUE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HeaderKeys getKey() {
        return this.key;
    }

    @Override
    public String asString() {
        return Objects.nonNull(this.value) ? this.value : this.nettyHeaders.get(this.name);
    }

    @Override
    public byte[] asBytes() {
        String header = this.asString();
        if (Objects.nonNull(header)) {
            return header.getBytes();
        }
        return null;
    }

    @Override
    public Date asDate() throws ParseException {
        return HttpDispatcher.getDateFormatter().parseTime(this.asString());
    }

    @Override
    public int asInteger() throws NumberFormatException {
        return this.nettyHeaders.getInt((CharSequence)this.name);
    }

    @Override
    public List<byte[]> asTokens(byte delimiter) {
        throw new UnsupportedOperationException("Unused in Netty Context");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.message.NettyHeader", NettyHeader.class, null, null);
    }
}

