/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.visit;

import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.util.lang.ArrayUtils;

public class PartialVisitContext
extends VisitContext {
    private final Collection<String> _clientIds;
    private final Collection<String> _ids;
    private final Collection<String> _unvisitedClientIds;
    private final Map<String, Collection<String>> _subtreeClientIds;
    private final FacesContext _facesContext;
    private final Set<VisitHint> _hints;

    public PartialVisitContext(FacesContext facesContext, Collection<String> clientIds) {
        this(facesContext, clientIds, null);
    }

    public PartialVisitContext(FacesContext facesContext, Collection<String> clientIds, Set<VisitHint> hints) {
        Assert.notNull(facesContext, "facesContext");
        this._facesContext = facesContext;
        this._unvisitedClientIds = new HashSet<String>();
        this._ids = new HashSet<String>();
        this._subtreeClientIds = new HashMap<String, Collection<String>>();
        this._clientIds = new CollectionProxy<String>(new HashSet());
        ArrayUtils.addAll(this._clientIds, clientIds);
        EnumSet<VisitHint> hintsEnumSet = hints == null || hints.isEmpty() ? EnumSet.noneOf(VisitHint.class) : EnumSet.copyOf(hints);
        this._hints = Collections.unmodifiableSet(hintsEnumSet);
    }

    public FacesContext getFacesContext() {
        return this._facesContext;
    }

    public Set<VisitHint> getHints() {
        return this._hints;
    }

    public Collection<String> getIdsToVisit() {
        return this._clientIds;
    }

    public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        String clientId = component.getClientId(this.getFacesContext());
        Collection<String> ids = this._subtreeClientIds.get(clientId);
        if (ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(ids);
    }

    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
        String clientId = this._getVisitId(component);
        if (clientId == null) {
            return VisitResult.ACCEPT;
        }
        VisitResult result = callback.visit((VisitContext)this, component);
        this._unvisitedClientIds.remove(clientId);
        if (this._unvisitedClientIds.isEmpty()) {
            return VisitResult.COMPLETE;
        }
        return result;
    }

    private void _idAdded(String clientId) {
        this._ids.add(this._getIdFromClientId(clientId));
        this._unvisitedClientIds.add(clientId);
        this._addSubtreeClientId(clientId);
    }

    private void _idRemoved(String clientId) {
        this._unvisitedClientIds.remove(clientId);
        this._removeSubtreeClientId(clientId);
    }

    private String _getVisitId(UIComponent component) {
        String id = component.getId();
        if (id != null && !this._ids.contains(id)) {
            return null;
        }
        String clientId = component.getClientId(this.getFacesContext());
        assert (clientId != null);
        return this._clientIds.contains(clientId) ? clientId : null;
    }

    private String _getIdFromClientId(String clientId) {
        char separator = this.getFacesContext().getNamingContainerSeparatorChar();
        int lastIndex = clientId.lastIndexOf(separator);
        String id = null;
        if (lastIndex < 0) {
            id = clientId;
        } else if (lastIndex < clientId.length() - 1) {
            id = clientId.substring(lastIndex + 1);
        }
        return id;
    }

    private void _addSubtreeClientId(String clientId) {
        char separator = this.getFacesContext().getNamingContainerSeparatorChar();
        int length = clientId.length();
        for (int i = 0; i < length; ++i) {
            if (clientId.charAt(i) != separator) continue;
            String namingContainerClientId = clientId.substring(0, i);
            Collection<String> c = this._subtreeClientIds.get(namingContainerClientId);
            if (c == null) {
                c = new ArrayList<String>(5);
                this._subtreeClientIds.put(namingContainerClientId, c);
            }
            c.add(clientId);
        }
    }

    private void _removeSubtreeClientId(String clientId) {
        for (Map.Entry<String, Collection<String>> stringCollectionEntry : this._subtreeClientIds.entrySet()) {
            if (!clientId.startsWith(stringCollectionEntry.getKey())) continue;
            Collection<String> ids = stringCollectionEntry.getValue();
            ids.remove(clientId);
        }
    }

    private class CollectionProxy<E extends String>
    extends AbstractCollection<E> {
        private final Collection<E> _wrapped;

        private CollectionProxy(Collection<E> wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public int size() {
            return this._wrapped.size();
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorProxy<E>(this._wrapped.iterator());
        }

        @Override
        public boolean add(E o) {
            boolean added = this._wrapped.add(o);
            if (added) {
                PartialVisitContext.this._idAdded((String)o);
            }
            return added;
        }
    }

    private class IteratorProxy<E extends String>
    implements Iterator<E> {
        private final Iterator<E> _wrapped;
        private E _current = null;

        private IteratorProxy(Iterator<E> wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this._wrapped.hasNext();
        }

        @Override
        public E next() {
            this._current = (String)this._wrapped.next();
            return this._current;
        }

        @Override
        public void remove() {
            if (this._current != null) {
                PartialVisitContext.this._idRemoved((String)this._current);
            }
            this._wrapped.remove();
        }
    }
}

