/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.faces40.internal.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.faces40.internal.config.WASApplicationImpl;
import io.openliberty.faces40.internal.extprocessor.JSFExtensionFactory;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class WASApplicationFactoryImpl
extends ApplicationFactory {
    private static final String CLASS_NAME = WASApplicationFactoryImpl.class.getName();
    private static final Logger log = Logger.getLogger(CLASS_NAME);
    private ApplicationFactory _applicationFactory;
    private Application _application;
    static final long serialVersionUID = -1714858710971621783L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WASApplicationFactoryImpl(ApplicationFactory applicationFactory) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "<init>", new Object[]{applicationFactory});
        }
        this._applicationFactory = applicationFactory;
        if (log.isLoggable(Level.FINE)) {
            log.fine("New WASApplicationFactory instance created");
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Application getApplication() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "getApplication", new Object[0]);
        }
        if (this._application == null) {
            WASApplicationFactoryImpl wASApplicationFactoryImpl = this;
            synchronized (wASApplicationFactoryImpl) {
                if (this._application == null) {
                    this._application = new WASApplicationImpl(this._applicationFactory.getApplication());
                    JSFExtensionFactory.initializeCDIJSFELContextListenerAndELResolver(this._application);
                }
            }
        }
        Application application = this._application;
        if (log != null && log.isLoggable(Level.FINER)) {
            application = application;
            log.exiting("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "getApplication", application);
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setApplication(Application application) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "setApplication", new Object[]{application});
        }
        WASApplicationFactoryImpl wASApplicationFactoryImpl = this;
        synchronized (wASApplicationFactoryImpl) {
            if (application == null) {
                throw new NullPointerException("Cannot set a null application in the ApplicationFactory");
            }
            this._application = application;
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "setApplication");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ApplicationFactory getWrapped() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "getWrapped", new Object[0]);
        }
        ApplicationFactory applicationFactory = this._applicationFactory;
        if (log != null && log.isLoggable(Level.FINER)) {
            applicationFactory = applicationFactory;
            log.exiting("io.openliberty.faces40.internal.config.WASApplicationFactoryImpl", "getWrapped", applicationFactory);
        }
        return applicationFactory;
    }
}

