/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.ObjectKeyData;
import org.apache.yoko.util.Hex;

public final class ObjectKey {
    static final Logger logger = Logger.getLogger(ObjectKey.class.getName());

    public static byte[] CreateObjectKey(ObjectKeyData id) {
        int i;
        int n;
        int len = id.serverId.length() + 1;
        for (int i2 = 0; i2 < id.poaId.length; ++i2) {
            len += id.poaId[i2].length() + 1;
        }
        ++len;
        len += 3;
        ++len;
        String time = null;
        if (!id.persistent) {
            time = "" + id.createTime;
            len += time.length() + 1;
        }
        byte[] key = new byte[id.oid.length + len];
        int data = 0;
        key[data++] = -85;
        key[data++] = -84;
        key[data++] = -85;
        if (id.persistent) {
            key[data++] = 48;
        } else {
            key[data++] = 49;
            n = time.length();
            for (i = 0; i < n; ++i) {
                key[data++] = (byte)time.charAt(i);
            }
            ++data;
        }
        n = id.serverId.length();
        for (int j = 0; j < n; ++j) {
            key[data++] = (byte)id.serverId.charAt(j);
        }
        ++data;
        for (i = 0; i < id.poaId.length; ++i) {
            n = id.poaId[i].length();
            for (int j = 0; j < n; ++j) {
                key[data++] = (byte)id.poaId[i].charAt(j);
            }
            ++data;
        }
        System.arraycopy(id.oid, 0, key, ++data, id.oid.length);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Created object key\n" + Hex.formatHexPara((byte[])key));
        }
        return key;
    }

    public static boolean ParseObjectKey(byte[] key, ObjectKeyData keyData) {
        int data = 0;
        int end = key.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Parsing object key\n" + Hex.formatHexPara((byte[])key));
        }
        if (key.length > 4 && key[0] == -85 && key[1] == -84 && key[2] == -85) {
            if (key[data += 3] == 48) {
                logger.fine("Parsing persistent object key");
                keyData.persistent = true;
                keyData.createTime = 0;
                ++data;
            } else {
                if (key[data] != 49) {
                    logger.fine("Characters '1' expected at position " + data);
                    return false;
                }
                keyData.persistent = false;
                int start = ++data;
                while (data < end && key[data] != 0) {
                    ++data;
                }
                if (data >= end) {
                    logger.fine("Missing '\u0000' in key data");
                    return false;
                }
                String t = new String(key, start, data - start);
                try {
                    keyData.createTime = Integer.valueOf(t);
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.FINE, "Invalid timestamp in key data", ex);
                    return false;
                }
                ++data;
            }
            boolean first = true;
            Vector<String> poaId = new Vector<String>();
            while (data < end) {
                int start = data;
                while (data < end && key[data] != 0) {
                    ++data;
                }
                if (data >= end) {
                    logger.fine("Missing '\u0000' in key data");
                    return false;
                }
                if (first) {
                    keyData.serverId = new String(key, start, data - start);
                    logger.fine("Parsed serverId=" + keyData.serverId);
                    first = false;
                } else {
                    String element = new String(key, start, data - start);
                    logger.fine("Parsed POA name=" + element);
                    poaId.addElement(element);
                }
                if (key[++data] != 0) continue;
                ++data;
                break;
            }
            keyData.poaId = new String[poaId.size()];
            poaId.copyInto(keyData.poaId);
            if (data >= end) {
                logger.fine("Missing object id in key data");
                return false;
            }
            int len = end - data;
            keyData.oid = new byte[len];
            System.arraycopy(key, data, keyData.oid, 0, len);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Parsed object id is\n" + Hex.formatHexPara((byte[])keyData.oid));
            }
            return true;
        }
        logger.fine("Invalid magic number in object key");
        return false;
    }
}

