/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class ViewBuilder {
    @Nullable
    private String name;
    @Nullable
    private String description;
    private Aggregation aggregation = Aggregation.defaultAggregation();
    private AttributesProcessor processor = AttributesProcessor.noop();
    private int cardinalityLimit = 2000;

    ViewBuilder() {
    }

    public ViewBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ViewBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ViewBuilder setAggregation(Aggregation aggregation) {
        if (!(aggregation instanceof AggregatorFactory)) {
            throw new IllegalArgumentException("Custom Aggregation implementations are currently not supported. Use one of the standard implementations returned by the static factories in the Aggregation class.");
        }
        this.aggregation = aggregation;
        return this;
    }

    public ViewBuilder setAttributeFilter(Set<String> keysToRetain) {
        Objects.requireNonNull(keysToRetain, "keysToRetain");
        return this.setAttributeFilter(AttributesProcessor.setIncludes(keysToRetain));
    }

    public ViewBuilder setAttributeFilter(Predicate<String> keyFilter) {
        Objects.requireNonNull(keyFilter, "keyFilter");
        this.processor = AttributesProcessor.filterByKeyName(keyFilter);
        return this;
    }

    ViewBuilder addAttributesProcessor(AttributesProcessor attributesProcessor) {
        this.processor = this.processor.then(attributesProcessor);
        return this;
    }

    ViewBuilder setCardinalityLimit(int cardinalityLimit) {
        if (cardinalityLimit <= 0) {
            throw new IllegalArgumentException("cardinalityLimit must be > 0");
        }
        this.cardinalityLimit = cardinalityLimit;
        return this;
    }

    public View build() {
        return View.create(this.name, this.description, this.aggregation, this.processor, this.cardinalityLimit);
    }
}

