/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.reactive.messaging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import io.openliberty.microprofile.reactive.messaging.internal.interfaces.RMAsyncProvider;
import io.openliberty.microprofile.reactive.messaging.internal.interfaces.RMAsyncProviderFactory;
import io.openliberty.microprofile.reactive.messaging.internal.interfaces.RMContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class RMAsyncProviderFactoryImpl
implements RMAsyncProviderFactory {
    private static final TraceComponent tc = Tr.register(RMAsyncProviderFactoryImpl.class, (String)"REACTIVEMESSAGE", (String)"io.openliberty.microprofile.reactive.messaging.internal.ReactiveMessagingProvider");
    private static final Map<String, ?>[] DEFAULT_CONTEXT_PROVIDERS = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.classloader.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.javaee.metadata.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    @Reference(target="(service.pid=com.ibm.ws.context.manager)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile WSContextService builtInContextService;
    @Reference(target="(id=DefaultContextService)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile WSContextService defaultContextService;
    private final Map<String, WSContextService> namedContextServices = new ConcurrentHashMap<String, WSContextService>();
    @Reference(target="(component.name=com.ibm.ws.threading)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ExecutorService globalExecutor;
    @Reference(target="(deferrable=false)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ScheduledExecutorService scheduledExecutor;
    static final long serialVersionUID = -7165047435269699060L;

    @Reference(service=WSContextService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    protected void addContextService(WSContextService contextService, Map<String, Object> properties) {
        String name = this.getContextServiceName(properties);
        if (name != null && !this.isApplicationDefinedContextService(properties)) {
            this.namedContextServices.put(name, contextService);
        }
    }

    protected void updatedContextService(WSContextService contextService, Map<String, Object> properties) {
        String name = this.getContextServiceName(properties);
        if (name == null || this.isApplicationDefinedContextService(properties)) {
            this.namedContextServices.values().remove(contextService);
        } else if (!contextService.equals(this.namedContextServices.get(name))) {
            this.namedContextServices.values().remove(contextService);
            this.namedContextServices.put(name, contextService);
        }
    }

    protected void removeContextService(WSContextService contextService) {
        this.namedContextServices.values().remove(contextService);
    }

    private String getContextServiceName(Map<String, Object> properties) {
        Object name = properties.get("id");
        if (name instanceof String) {
            return (String)name;
        }
        return null;
    }

    private boolean isApplicationDefinedContextService(Map<String, Object> properties) {
        return !"file".equals(properties.get("config.source"));
    }

    @Override
    public RMAsyncProvider getAsyncProvider(String contextServiceRef, String channelName) {
        if (contextServiceRef != null) {
            this.getNamedContextService(contextServiceRef, channelName);
        }
        return new NamedAsyncProvider(contextServiceRef, channelName);
    }

    private RMContext captureContext(String contextServiceName, String channel) {
        WSContextService namedContextService = null;
        if (contextServiceName != null && !contextServiceName.isEmpty()) {
            namedContextService = this.getNamedContextService(contextServiceName, channel);
        }
        if (namedContextService != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Capturing context with named context service", (Object[])new Object[]{contextServiceName, namedContextService});
            }
            return new RMContextImpl(namedContextService.captureThreadContext(null, new Map[0]));
        }
        if (this.defaultContextService != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Capturing context with default context service", (Object[])new Object[0]);
            }
            return new RMContextImpl(this.defaultContextService.captureThreadContext(null, new Map[0]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Capturing context with build-in context service", (Object[])new Object[0]);
        }
        return new RMContextImpl(this.builtInContextService.captureThreadContext(null, (Map[])DEFAULT_CONTEXT_PROVIDERS));
    }

    private WSContextService getNamedContextService(String contextServiceName, String channelName) {
        WSContextService result = this.namedContextServices.get(contextServiceName);
        if (result == null) {
            Tr.error((TraceComponent)tc, (String)"missing.context.service.CWMRX1200E", (Object[])new Object[]{channelName, contextServiceName});
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"missing.context.service.CWMRX1200E", (Object[])new Object[]{channelName, contextServiceName}));
        }
        return result;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class NamedAsyncProvider
    implements RMAsyncProvider {
        private final String name;
        private final String channelName;
        static final long serialVersionUID = -2813637082562896765L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NamedAsyncProvider(String name, String channelName) {
            this.name = name;
            this.channelName = channelName;
        }

        @Override
        public RMContext captureContext() {
            return RMAsyncProviderFactoryImpl.this.captureContext(this.name, this.channelName);
        }

        @Override
        public ExecutorService getExecutorService() {
            return RMAsyncProviderFactoryImpl.this.globalExecutor;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return RMAsyncProviderFactoryImpl.this.scheduledExecutor;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.reactive.messaging.internal.RMAsyncProviderFactoryImpl$NamedAsyncProvider", NamedAsyncProvider.class, (String)"REACTIVEMESSAGE", (String)"io.openliberty.microprofile.reactive.messaging.internal.ReactiveMessagingProvider");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RMContextImpl
    implements RMContext {
        private final ThreadContextDescriptor context;
        static final long serialVersionUID = 4337207750338572230L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RMContextImpl(ThreadContextDescriptor context) {
            this.context = context;
        }

        @Override
        public void execute(Runnable runnable) {
            ArrayList contextApplied = this.context.taskStarting();
            try {
                runnable.run();
            }
            finally {
                this.context.taskStopping(contextApplied);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.reactive.messaging.internal.RMAsyncProviderFactoryImpl$RMContextImpl", RMContextImpl.class, (String)"REACTIVEMESSAGE", (String)"io.openliberty.microprofile.reactive.messaging.internal.ReactiveMessagingProvider");
        }
    }
}

