/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonUtils {
    public static Object toValue(JsonValue value) {
        switch (value.getValueType()) {
            case NULL: {
                return null;
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).numberValue();
            }
            case ARRAY: {
                return JsonUtils.toList(value.asJsonArray());
            }
            case OBJECT: {
                return JsonUtils.toMap(value.asJsonObject());
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Object toList(JsonArray value) {
        return value.stream().map(JsonUtils::toValue).collect(Collectors.toList());
    }

    public static Map<String, Object> toMap(JsonObject jsonObject) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), JsonUtils.toValue((JsonValue)entry.getValue()));
        }
        return map;
    }

    public static boolean isListOf(JsonValue jsonValue, String typename) {
        return jsonValue.getValueType() == JsonValue.ValueType.ARRAY && jsonValue.asJsonArray().size() > 0 && ((JsonValue)jsonValue.asJsonArray().get(0)).getValueType() == JsonValue.ValueType.OBJECT && typename.equals(((JsonValue)jsonValue.asJsonArray().get(0)).asJsonObject().getString("__typename", null));
    }
}

