/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

public class MetricsService
implements EventingService {
    private MetricRegistry metricRegistry;
    private final Map<Context, Long> startTimes = Collections.synchronizedMap(new IdentityHashMap());
    private static final String METRIC_NAME = "mp_graphql";
    private final String DESCRIPTION = "Call statistics for the operation denoted by the 'name' tag";

    @Override
    public Operation createOperation(Operation operation) {
        Tag[] tags = this.getTags(operation);
        Metadata metadata = Metadata.builder().withName(METRIC_NAME).withType(MetricType.SIMPLE_TIMER).withDescription("Call statistics for the operation denoted by the 'name' tag").build();
        this.getMetricRegistry().simpleTimer(metadata, tags);
        return operation;
    }

    @Override
    public void beforeDataFetch(Context context) {
        this.startTimes.put(context, System.nanoTime());
    }

    @Override
    public void afterDataFetch(Context context) {
        Long startTime = this.startTimes.remove(context);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            this.getMetricRegistry().simpleTimer(METRIC_NAME, this.getTags(context)).update(Duration.ofNanos(duration));
        }
    }

    @Override
    public String getConfigKey() {
        return "smallrye.graphql.metrics.enabled";
    }

    private MetricRegistry getMetricRegistry() {
        if (this.metricRegistry == null) {
            this.metricRegistry = (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[]{new VendorType()}).get();
        }
        return this.metricRegistry;
    }

    private Tag[] getTags(Context context) {
        return new Tag[]{new Tag("name", context.getFieldName()), new Tag("type", context.getOperationType()), new Tag("source", String.valueOf(context.getSource() != null))};
    }

    private Tag[] getTags(Operation operation) {
        return new Tag[]{new Tag("name", operation.getName()), new Tag("type", operation.getOperationType().toString()), new Tag("source", String.valueOf(operation.isSourceField()))};
    }

    class VendorType
    extends AnnotationLiteral<RegistryType>
    implements RegistryType {
        VendorType() {
        }

        public MetricRegistry.Type type() {
            return MetricRegistry.Type.VENDOR;
        }
    }
}

