/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.filter;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.filter.ContainsCondition;
import com.ibm.ws.security.oauth20.filter.EqualCondition;
import com.ibm.ws.security.oauth20.filter.FilterException;
import com.ibm.ws.security.oauth20.filter.GreaterCondition;
import com.ibm.ws.security.oauth20.filter.ICondition;
import com.ibm.ws.security.oauth20.filter.IRequestInfo;
import com.ibm.ws.security.oauth20.filter.IValue;
import com.ibm.ws.security.oauth20.filter.LessCondition;
import com.ibm.ws.security.oauth20.filter.NotContainsCondition;
import com.ibm.ws.security.oauth20.filter.OrCondition;
import com.ibm.ws.security.oauth20.filter.ValueAddressRange;
import com.ibm.ws.security.oauth20.filter.ValueIPAddress;
import com.ibm.ws.security.oauth20.filter.ValueString;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CommonHTTPHeaderFilter {
    private static final TraceComponent tc = Tr.register(CommonHTTPHeaderFilter.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.tai.resources.OAuthTaiMessages");
    protected boolean nonFilter = false;
    protected boolean processAll = false;
    protected static final String APPLICATION_NAMES = "applicationNames";
    protected static final String REFERRER = "Referer";
    protected List<ICondition> filterCondition = new LinkedList<ICondition>();
    static final long serialVersionUID = -6850110491301232031L;

    public CommonHTTPHeaderFilter() {
    }

    public CommonHTTPHeaderFilter(String s1) {
        this.init(s1);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public boolean init(String s1) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)s1, (Object[])new Object[0]);
        }
        if (s1 == null) {
            this.nonFilter = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Filter Not Defined", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"init", (Object)Boolean.toString(false));
            }
            return false;
        }
        StringTokenizer st1 = new StringTokenizer(s1, ";");
        StringTokenizer st2 = null;
        String s2 = null;
        while (st1.hasMoreTokens()) {
            s2 = st1.nextToken();
            st2 = new StringTokenizer(s2, "^=!<>%");
            String key = st2.nextToken();
            if (!st2.hasMoreTokens()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)s2, (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"init", (Object)Boolean.toString(false));
                }
                return false;
            }
            String valueString = st2.nextToken();
            String operand = s2.substring(key.length(), s2.length() - valueString.length()).trim();
            boolean ipAddress = false;
            if ("remote-address".equals(key)) {
                ipAddress = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isValid", (Object[])new Object[]{"Adding " + key + " " + operand + " " + valueString});
            }
            try {
                ICondition condition = this.makeCondition(key, operand, valueString, ipAddress);
                this.filterCondition.add(condition);
            }
            catch (FilterException condition) {
                void e;
                FFDCFilter.processException((Throwable)condition, (String)"com.ibm.ws.security.oauth20.filter.CommonHTTPHeaderFilter", (String)"95", (Object)this, (Object[])new Object[]{s1});
                throw new RuntimeException((Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init", (Object)Boolean.toString(true));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected boolean isAccepted(IRequestInfo req) {
        String reason = "TAI will intercept request.";
        boolean isAccepted = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[0]);
        }
        if (this.processAll) {
            reason = "processAll is true, therefore we always intercept.";
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isAccepted", (Object)(isAccepted + " " + reason));
            }
            return true;
        }
        String HTTPheader = null;
        for (ICondition cond : this.filterCondition) {
            HTTPheader = req.getHeader(cond.getKey());
            boolean ipAddress = false;
            if (HTTPheader == null) {
                String queryString;
                if (cond.getKey().equals("remote-address")) {
                    HTTPheader = req.getRemoteAddr();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"HTTPheader obtained from 'remote-address' " + HTTPheader});
                    }
                    ipAddress = true;
                } else if (cond.getKey().equals("request-url")) {
                    queryString = req.getQueryString();
                    HTTPheader = queryString != null ? req.getRequestURL().toString() + "?" + queryString : req.getRequestURL().toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"HTTPheader obtained from 'request-url' " + HTTPheader});
                    }
                } else if (cond.getKey().equals("request-uri")) {
                    HTTPheader = req.getRequestURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"HTTPheader obtained from 'request-uri' " + HTTPheader});
                    }
                } else if (cond.getKey().equals(REFERRER)) {
                    HTTPheader = req.getReferer();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"HTTPheader obtained from 'Referer' " + HTTPheader});
                    }
                } else if (cond.getKey().equals(APPLICATION_NAMES)) {
                    queryString = req.getApplicationName();
                    if (queryString != null) {
                        HTTPheader = queryString;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"ApplicationName:" + HTTPheader});
                    }
                } else {
                    if (cond instanceof NotContainsCondition) continue;
                    reason = "No HTTPheader found, and no 'remote-address' or 'request-url' rule used - do not Intercept.";
                    isAccepted = false;
                    break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"Checking condition:" + cond});
            }
            try {
                IValue compareValue = ipAddress ? new ValueIPAddress(HTTPheader) : new ValueString(HTTPheader);
                boolean answer = cond.checkCondition(compareValue);
                if (!answer) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"check failed, returning false. TAI will not intercept"});
                    }
                    isAccepted = false;
                    break;
                }
                isAccepted = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"isAccepted", (Object[])new Object[]{"check passed, continuing to next condition"});
            }
            catch (FilterException compareValue) {
                void e;
                FFDCFilter.processException((Throwable)compareValue, (String)"com.ibm.ws.security.oauth20.filter.CommonHTTPHeaderFilter", (String)"211", (Object)this, (Object[])new Object[]{req});
                throw new RuntimeException((Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isAccepted", (Object)"TAI will intercept request");
            Tr.exit((TraceComponent)tc, (String)"isAccepted", (Object)(isAccepted + " " + reason));
        }
        return isAccepted;
    }

    private ICondition makeCondition(String key, String operand, String valueString, boolean ipAddress) throws FilterException {
        if (operand.equals("==")) {
            return new EqualCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals("!=")) {
            return new NotContainsCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals("^=")) {
            OrCondition cond = new OrCondition(key);
            StringTokenizer tokens = new StringTokenizer(valueString, "|");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                cond.addValue(this.makeValue(token, ipAddress));
            }
            return cond;
        }
        if (operand.equals("%=")) {
            return new ContainsCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals("<")) {
            return new LessCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals(">")) {
            return new GreaterCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init", (Object[])new Object[]{operand});
        }
        throw new FilterException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.oauth20.internal.tai.resources.OAuthTaiMessages", (String)"security.tai.malformed.filter.operator", (Object[])new Object[]{operand}, (String)"CWTAI0019E: Filter operator should be one of ''=='', ''!='', ''%='', ''^='', ''>'' or ''<''. Operator used was {0}."));
    }

    private IValue makeValue(String value, boolean ipAddress) throws FilterException {
        if (ipAddress) {
            return new ValueAddressRange(value);
        }
        return new ValueString(value);
    }

    public void setProcessAll(boolean b) {
        this.processAll = b;
    }

    public boolean noFilter() {
        return this.nonFilter;
    }
}

