/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.exporter.internal.RetryUtil;
import io.opentelemetry.exporter.internal.auth.Authenticator;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.sender.okhttp.internal.OkHttpUtil;
import io.opentelemetry.exporter.sender.okhttp.internal.RetryInterceptor;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public final class OkHttpHttpSender
implements HttpSender {
    private final OkHttpClient client;
    private final HttpUrl url;
    private final boolean compressionEnabled;
    private final Supplier<Map<String, String>> headerSupplier;
    private final MediaType mediaType;

    public OkHttpHttpSender(String endpoint, boolean compressionEnabled, String contentType, long timeoutNanos, Supplier<Map<String, String>> headerSupplier, @Nullable Authenticator authenticator, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(timeoutNanos));
        if (authenticator != null) {
            Authenticator finalAuthenticator = authenticator;
            builder.authenticator((route, response) -> {
                Request.Builder requestBuilder = response.request().newBuilder();
                finalAuthenticator.getHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
                return requestBuilder.build();
            });
        }
        if (retryPolicy != null) {
            builder.addInterceptor((Interceptor)new RetryInterceptor(retryPolicy, OkHttpHttpSender::isRetryable));
        }
        if (sslContext != null && trustManager != null) {
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        this.client = builder.build();
        this.url = HttpUrl.get((String)endpoint);
        this.compressionEnabled = compressionEnabled;
        this.mediaType = MediaType.parse((String)contentType);
        this.headerSupplier = headerSupplier;
    }

    @Override
    public void send(Consumer<OutputStream> marshaler, int contentLength, final Consumer<HttpSender.Response> onResponse, final Consumer<Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        this.headerSupplier.get().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        RawRequestBody body = new RawRequestBody(marshaler, contentLength, this.mediaType);
        if (this.compressionEnabled) {
            requestBuilder.addHeader("Content-Encoding", "gzip");
            requestBuilder.post((RequestBody)new GzipRequestBody(body));
        } else {
            requestBuilder.post((RequestBody)body);
        }
        this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                onError.accept(e);
            }

            public void onResponse(Call call, final Response response) {
                try (final ResponseBody body = response.body();){
                    onResponse.accept(new HttpSender.Response(){

                        @Override
                        public int statusCode() {
                            return response.code();
                        }

                        @Override
                        public String statusMessage() {
                            return response.message();
                        }

                        @Override
                        public byte[] responseBody() throws IOException {
                            return body.bytes();
                        }
                    });
                }
            }
        });
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    static boolean isRetryable(Response response) {
        return RetryUtil.retryableHttpResponseCodes().contains(response.code());
    }

    private static class RawRequestBody
    extends RequestBody {
        private final Consumer<OutputStream> marshaler;
        private final int contentLength;
        private final MediaType mediaType;

        private RawRequestBody(Consumer<OutputStream> marshaler, int contentLength, MediaType mediaType) {
            this.marshaler = marshaler;
            this.contentLength = contentLength;
            this.mediaType = mediaType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public void writeTo(BufferedSink bufferedSink) {
            this.marshaler.accept(bufferedSink.outputStream());
        }
    }

    private static class GzipRequestBody
    extends RequestBody {
        private final RequestBody requestBody;

        private GzipRequestBody(RequestBody requestBody) {
            this.requestBody = requestBody;
        }

        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        public long contentLength() {
            return -1L;
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)bufferedSink));
            this.requestBody.writeTo(gzipSink);
            gzipSink.close();
        }
    }
}

