/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulation;
import com.ibm.ws.sib.mfp.jmf.JMFList;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFMessageData;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.CompatibilityMap;
import com.ibm.ws.sib.mfp.jmf.impl.JSBoxManager;
import com.ibm.ws.sib.mfp.jmf.impl.JSCompatibleBoxList;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageData;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSVaryingListImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.utils.DataSlice;
import java.util.List;

public final class JSCompatibleMessageImpl
implements JMFMessage {
    private static TraceComponent tc = JmfTr.register(JSCompatibleMessageImpl.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private JSchema access;
    private JMFNativePart encoding;
    private CompatibilityMap map;
    private JSBoxManager boxManager;

    public JSCompatibleMessageImpl(JSchema access, JMFNativePart encoding) throws JMFSchemaViolationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", new Object[]{access, encoding});
        }
        this.access = access;
        this.encoding = encoding;
        if (encoding instanceof JSMessageData) {
            ((JSMessageData)((Object)encoding)).setCompatibilityWrapper(this);
        }
        this.map = ((JSchema)encoding.getEncodingSchema()).getCompatibility(access);
        int[][] boxed = access.getBoxed();
        if (boxed.length > 0) {
            this.boxManager = new JSBoxManager(this, boxed);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    private JSCompatibleMessageImpl(JSCompatibleMessageImpl original) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", original);
        }
        this.access = original.access;
        this.map = original.map;
        if (original.boxManager != null) {
            this.boxManager = new JSBoxManager(this, this.access.getBoxed());
        }
        this.encoding = ((JMFMessage)original.encoding).copy();
        if (this.encoding instanceof JSMessageData) {
            ((JSMessageData)((Object)this.encoding)).setCompatibilityWrapper(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    @Override
    public final Object getMessageLockArtefact() {
        if (this.encoding instanceof JMFMessage) {
            return ((JMFMessage)this.encoding).getMessageLockArtefact();
        }
        return this;
    }

    final JMFNativePart getEncodingMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getEncodingMessage");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getEncodingMessage", this.encoding);
        }
        return this.encoding;
    }

    @Override
    public short getJMFEncodingVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "getJMFEncodingVersion");
        }
        return ((JMFMessage)this.encoding).getJMFEncodingVersion();
    }

    @Override
    public JMFSchema[] getSchemata() throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "getSchemata");
        }
        return ((JMFMessage)this.encoding).getSchemata();
    }

    @Override
    public int originalFrame() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "originalFrame");
        }
        return ((JMFMessage)this.encoding).originalFrame();
    }

    @Override
    public int getEncodedLength() throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getEncodedLength");
        }
        int length = ((JMFMessage)this.encoding).getEncodedLength();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getEncodedLength", length);
        }
        return length;
    }

    @Override
    public int toByteArray(byte[] buffer, int offset, int length) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "toByteArray");
        }
        return ((JMFMessage)this.encoding).toByteArray(buffer, offset, length);
    }

    @Override
    public byte[] toByteArray(int length) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "toByteArray");
        }
        return ((JMFMessage)this.encoding).toByteArray(length);
    }

    @Override
    public JMFSchema getEncodingSchema() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getEncodingSchema");
        }
        JMFSchema schema = this.encoding.getEncodingSchema();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getEncodingSchema");
        }
        return schema;
    }

    @Override
    public JMFNativePart newNativePart(JMFSchema schema) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "newNativePart");
        }
        return this.encoding.newNativePart(schema);
    }

    @Override
    public int getModelID() {
        return 0;
    }

    @Override
    public JMFSchema getJMFSchema() {
        return this.access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMFMessage copy() {
        JMFMessage copy;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "copy");
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            copy = this.map == null ? ((JMFMessage)this.encoding).copy() : new JSCompatibleMessageImpl(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "copy", copy);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getValue", accessor);
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                Object ans = this.encoding.getValue(accessor);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "getValue", ans);
                }
                return ans;
            }
            if (accessor >= this.map.indices.length) {
                if (accessor >= this.access.getAccessorCount()) {
                    throw new IndexOutOfBoundsException(String.valueOf(accessor));
                }
                Object ans = this.boxManager.getBoxedlValue(accessor - this.map.indices.length);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "getValue", ans);
                }
                return ans;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            Object ans = this.encoding.getValue(encAccessor);
            if (encAccessor >= this.map.varBias) {
                ans = this.map.getCases[encAccessor - this.map.varBias][((Number)ans).intValue()];
            } else if (ans instanceof JSVaryingListImpl) {
                JSVaryingListImpl boxList = (JSVaryingListImpl)ans;
                if (boxList.element instanceof JSVariant) {
                    JSVariant thisVar = (JSVariant)this.access.getFieldDef(accessor);
                    ans = new JSCompatibleBoxList(thisVar, boxList);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getValue", ans);
            }
            return ans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getInt", accessor);
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                int ans = this.encoding.getInt(accessor);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "getInt", ans);
                }
                return ans;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            int ans = this.encoding.getInt(encAccessor);
            if (encAccessor >= this.map.varBias) {
                ans = this.map.getCases[encAccessor - this.map.varBias][ans];
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getInt", ans);
            }
            return ans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPresent(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "isPresent", accessor);
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            int enc;
            if (this.map == null) {
                boolean ans = this.encoding.isPresent(accessor);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "isPresent", ans);
                }
                return ans;
            }
            if (accessor >= this.map.indices.length) {
                if (accessor >= this.access.getAccessorCount()) {
                    throw new IndexOutOfBoundsException(String.valueOf(accessor));
                }
                accessor = this.boxManager.getBoxAccessor(accessor - this.map.indices.length);
            }
            if ((enc = this.map.indices[accessor]) == -1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "isPresent", Boolean.FALSE);
                }
                return false;
            }
            boolean ans = this.encoding.isPresent(enc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "isPresent", ans);
            }
            return ans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int accessor, Object val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setValue", new Object[]{accessor, val});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setValue(accessor, val);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "setValue");
                }
                return;
            }
            if (accessor >= this.map.indices.length) {
                if (accessor >= this.access.getAccessorCount()) {
                    throw new IndexOutOfBoundsException(String.valueOf(accessor));
                }
                this.boxManager.setBoxedValue(accessor - this.map.indices.length, val);
            } else {
                int encAccessor = this.map.indices[accessor];
                if (encAccessor == -1) {
                    this.becomeDelegator();
                    this.encoding.setValue(accessor, val);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        JmfTr.exit(this, tc, "setValue");
                    }
                    return;
                }
                if (encAccessor >= this.map.varBias) {
                    val = this.map.setCases[encAccessor - this.map.varBias][((Number)val).intValue()];
                }
                this.encoding.setValue(encAccessor, val);
            }
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setValue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeDelegator() throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "becomeDelegator");
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "becomeDelegator");
                }
                return;
            }
            JMFNativePart newEncoding = JMFRegistry.instance.newNativePart(this.access);
            JSCompatibleMessageImpl.transcribe(this.access, this.map, this.encoding, newEncoding);
            if (this.boxManager != null) {
                this.boxManager.reset();
            }
            if (((JSMessageData)((Object)newEncoding)).getParent() != null) {
                ((JSMessageData)((Object)newEncoding)).getParent().updateCacheEntry(this.encoding, newEncoding);
            }
            ((JSMessageData)((Object)newEncoding)).setCompatibilityWrapper(this);
            this.encoding = newEncoding;
            this.map = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "becomeDelegator");
        }
    }

    private static void transcribe(JSchema toSchema, CompatibilityMap map, JMFNativePart from, JMFNativePart to) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        int i;
        JMFMessageData parent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(tc, "transcribe", new Object[]{toSchema, map, from, to});
        }
        if ((parent = from instanceof JSMessageData ? ((JSMessageData)((Object)from)).getParent() : ((JMFEncapsulation)((Object)from)).getContainingMessageData()) != null) {
            ((JSMessageData)((Object)to)).setParent(parent);
        }
        JSVariant[] vars = toSchema.getVariants();
        for (int i2 = 0; i2 < vars.length; ++i2) {
            JSVariant var = vars[i2];
            int acc = var.getAccessor(toSchema);
            int enc = map.indices[acc];
            if (enc == -1 || !from.isPresent(enc)) continue;
            to.setInt(acc, map.getCases[enc - map.varBias][from.getInt(enc)]);
        }
        JSField[] fields = toSchema.getFields();
        for (i = 0; i < fields.length; ++i) {
            JSField field = fields[i];
            if (field instanceof JSVariant) {
                JSVariant var = (JSVariant)field;
                int acc = var.getBoxAccessor(toSchema);
                int enc = map.indices[acc];
                if (enc == -1 || !from.isPresent(enc)) continue;
                List fromList = (List)from.getValue(enc);
                JMFList toList = to.createBoxList(acc, fromList);
                JSchema accBoxSchema = (JSchema)var.getBoxed();
                JSchema encBoxSchema = (JSchema)((JSVariant)from.getJMFSchema().getFieldDef(enc)).getBoxed();
                CompatibilityMap boxMap = encBoxSchema.getCompatibility(accBoxSchema);
                JSCompatibleMessageImpl.transcribeList(accBoxSchema, boxMap, fromList, toList);
                continue;
            }
            int acc = field.getAccessor(toSchema);
            int enc = map.indices[acc];
            if (enc == -1 || !from.isPresent(enc)) continue;
            to.setValue(acc, from.getValue(enc));
        }
        for (i = 0; i < vars.length; ++i) {
            JSVariant var = vars[i];
            int acc = var.getAccessor(toSchema);
            if (to.getInt(acc) != -1 || map.indices[acc] != -1 || !((JSMessageImpl)to).consistentChoice(acc - fields.length)) continue;
            to.setInt(acc, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(tc, "transcribe");
        }
    }

    private static void transcribeList(JSchema toSchema, CompatibilityMap map, List fromList, List toList) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        for (int j = 0; j < fromList.size(); ++j) {
            Object from = fromList.get(j);
            Object to = toList.get(j);
            if (from instanceof JMFNativePart) {
                JSCompatibleMessageImpl.transcribe(toSchema, map, (JMFNativePart)from, (JMFNativePart)to);
                continue;
            }
            JSCompatibleMessageImpl.transcribeList(toSchema, map, (List)from, (List)to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int accessor, int val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setInt", new Object[]{accessor, val});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setInt(accessor, val);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "setInt");
                }
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setInt(accessor, val);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "setInt");
                }
                return;
            }
            if (encAccessor >= this.map.varBias) {
                val = this.map.setCases[encAccessor - this.map.varBias][val];
            }
            this.encoding.setInt(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setInt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getBoolean(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getBoolean(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getByte(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getByte(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getShort(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getShort(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getChar(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getChar(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getChar(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getLong(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getLong(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getFloat(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getFloat(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getDouble(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getDouble(encAccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int accessor, boolean val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setBoolean(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setBoolean(accessor, val);
                return;
            }
            this.encoding.setBoolean(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int accessor, byte val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setByte(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setByte(accessor, val);
                return;
            }
            this.encoding.setByte(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int accessor, short val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setShort(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setShort(accessor, val);
                return;
            }
            this.encoding.setShort(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChar(int accessor, char val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setChar(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setChar(accessor, val);
                return;
            }
            this.encoding.setChar(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int accessor, long val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setLong(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setLong(accessor, val);
                return;
            }
            this.encoding.setLong(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int accessor, float val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setFloat(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setFloat(accessor, val);
                return;
            }
            this.encoding.setFloat(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int accessor, double val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                this.encoding.setDouble(accessor, val);
                return;
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                this.becomeDelegator();
                this.encoding.setDouble(accessor, val);
                return;
            }
            this.encoding.setDouble(encAccessor, val);
            if (this.encoding instanceof JSMessageData && ((JSMessageData)((Object)this.encoding)).contents == null) {
                this.becomeDelegator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMFNativePart getNativePart(int accessor, JMFSchema schema) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getNativePart(accessor, schema);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getNativePart(encAccessor, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getModelID(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map == null) {
                return this.encoding.getModelID(accessor);
            }
            int encAccessor = this.map.indices[accessor];
            if (encAccessor == -1) {
                throw new JMFUninitializedAccessException("Invalid accessor: " + accessor);
            }
            return this.encoding.getModelID(encAccessor);
        }
    }

    @Override
    public void unassemble() throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "unassemble");
        }
        this.becomeDelegator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "unassemble");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMFList createBoxList(int accessor, Object val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.map != null) {
                this.becomeDelegator();
            }
            return this.encoding.createBoxList(accessor, val);
        }
    }

    @Override
    public DataSlice getAssembledContent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getAssembledContent");
        }
        DataSlice result = null;
        if (this.encoding instanceof JMFMessage) {
            result = ((JMFMessage)this.encoding).getAssembledContent();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getAssembledContent", result);
        }
        return result;
    }

    @Override
    public int estimateUnassembledValueSize(int index) {
        return this.encoding.estimateUnassembledValueSize(index);
    }

    @Override
    public boolean isEMPTYlist(int accessor) {
        if (this.encoding instanceof JMFMessage) {
            return ((JMFMessage)this.encoding).isEMPTYlist(accessor);
        }
        return false;
    }
}

