/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import javax.json.stream.JsonParsingException;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IntrospectUserApiUtils {
    public static final TraceComponent tc = Tr.register(IntrospectUserApiUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private static final JsonReaderFactory readerFactory = Json.createReaderFactory(null);
    SocialLoginConfig config = null;
    HttpUtils httpUtils = new HttpUtils();
    static final long serialVersionUID = 2062072527967814811L;

    public IntrospectUserApiUtils(Oauth2LoginConfigImpl config) {
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserApiResponse(@Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        String response = null;
        try {
            HttpURLConnection connection = this.sendUserApiRequest(accessToken, sslSocketFactory);
            response = this.readUserApiResponse(connection);
        }
        catch (Exception connection) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive java.lang.String>";
            objectArray[1] = sslSocketFactory;
            FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.security.social.internal.utils.IntrospectUserApiUtils", (String)"58", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("INTROSPECT_ERROR_GETTING_USER_INFO", (Exception)e, new Object[]{e});
        }
        return response;
    }

    HttpURLConnection sendUserApiRequest(@Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws IOException, SocialLoginException {
        HttpURLConnection connection = this.httpUtils.createConnection(HttpUtils.RequestMethod.POST, this.config.getUserApi(), sslSocketFactory);
        connection = this.httpUtils.setHeaders(connection, this.getUserApiRequestHeaders());
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        String postData = "token=" + accessToken + "&token_type_hint=" + this.config.getIntrospectionTokenTypeHint();
        outputStream.write(postData.getBytes());
        outputStream.close();
        connection.connect();
        return connection;
    }

    @Sensitive
    Map<String, String> getUserApiRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String idAndSecretEncoded = Base64Coder.base64Encode((String)(this.config.getClientId() + ":" + this.config.getClientSecret()));
        headers.put("Authorization", "Basic " + idAndSecretEncoded);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }

    String readUserApiResponse(HttpURLConnection connection) throws IOException, SocialLoginException {
        int responseCode = connection.getResponseCode();
        String response = this.httpUtils.readConnectionResponse(connection);
        if (responseCode != 200) {
            throw new SocialLoginException("USER_API_RESPONSE_BAD_STATUS", null, new Object[]{responseCode, response});
        }
        return this.modifyExistingResponseToJSON(response);
    }

    String modifyExistingResponseToJSON(String response) throws SocialLoginException {
        JsonObject jsonResponse = this.getJsonResponseIfValid(response);
        if (jsonResponse.getBoolean("active")) {
            return jsonResponse.toString();
        }
        throw new SocialLoginException("INTROSPECT_USER_API_INACTIVE", null, null);
    }

    /*
     * WARNING - void declaration
     */
    private JsonObject getJsonResponseIfValid(String response) throws SocialLoginException {
        if (response == null || response.isEmpty()) {
            throw new SocialLoginException("RESPONSE_NOT_JSON", null, null);
        }
        try {
            return readerFactory.createReader((Reader)new StringReader(response)).readObject();
        }
        catch (JsonParsingException jsonParsingException) {
            void e;
            FFDCFilter.processException((Throwable)jsonParsingException, (String)"com.ibm.ws.security.social.internal.utils.IntrospectUserApiUtils", (String)"114", (Object)this, (Object[])new Object[]{response});
            throw new SocialLoginException("RESPONSE_NOT_JSON", (Exception)e, new Object[]{response, e});
        }
    }
}

