/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.routers.dns;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.routers.Router;
import com.ibm.ws.sip.stack.transaction.transport.routers.dns.DNSSRVQueryResult;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.message.Request;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class DNSSRVRouter
implements Router {
    private static final String s_dnsServerPrefix = "com.ibm.sip.dnsserver";
    private static final LogMgr c_logger = Log.get(DNSSRVRouter.class);
    private List m_dnsServers;
    private DirContext m_context;
    private static final String QTYPE_SRV = "SRV";
    private static final String QTYPE_ADDRESS = "A";
    private static final String SIP_SERVICE = "sip";

    public DNSSRVRouter() {
        block2: {
            try {
                this.init();
            }
            catch (NamingException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block2;
                c_logger.traceDebug(this, "DNSSRVRouter", e2.getMessage());
            }
        }
    }

    private void init() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        this.m_dnsServers = this.readDNSServersFromConfig();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", this.getDNSServersAsProviderString());
        this.m_context = new InitialDirContext(env);
    }

    private List readDNSServersFromConfig() {
        String dnsServer;
        ArrayList<String> dnsServers = new ArrayList<String>(2);
        int lpNum = 1;
        while (!(dnsServer = ApplicationProperties.getProperties().getString("com.ibm.sip.dnsserver." + lpNum)).equals("")) {
            ++lpNum;
            dnsServers.add(dnsServer);
        }
        return dnsServers;
    }

    private String getDNSServersAsProviderString() {
        StringBuffer retval = new StringBuffer("");
        for (int i = 0; i < this.m_dnsServers.size(); ++i) {
            if (i > 0) {
                retval.append(" ");
            }
            retval.append("dns://" + this.m_dnsServers.get(i));
        }
        return retval.toString();
    }

    @Override
    public List getNextHops(Request sipRequest) {
        ArrayList retval;
        block9: {
            retval = new ArrayList(3);
            try {
                SipURL uriToFind;
                if (sipRequest.hasRouteHeaders()) {
                    NameAddressHeader routeHeader = (NameAddressHeader)sipRequest.getHeader("Route", true);
                    uriToFind = (SipURL)routeHeader.getNameAddress().getAddress();
                } else {
                    uriToFind = (SipURL)sipRequest.getRequestURI();
                }
                try {
                    retval.addAll(this.getHostAddressesTypeResults(uriToFind));
                }
                catch (UnknownHostException exp) {
                    try {
                        retval.addAll(this.getDNSSrvTypeResults(uriToFind));
                    }
                    catch (UnknownHostException e2) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "getNextHops", exp.getMessage());
                        }
                    }
                }
            }
            catch (SipException exp) {
                if (!c_logger.isTraceDebugEnabled()) break block9;
                c_logger.traceDebug(this, "getNextHops", exp.getMessage(), exp);
            }
        }
        return retval;
    }

    private List getHostAddressesTypeResults(SipURL uriToFind) throws UnknownHostException {
        ArrayList<String> hosts;
        String tempHost;
        ArrayList<Hop> retVal = new ArrayList<Hop>(3);
        String string = tempHost = uriToFind.hasMAddr() ? uriToFind.getMAddr() : uriToFind.getHost();
        if (Character.isDigit(tempHost.charAt(0))) {
            hosts = new ArrayList<String>(3);
            hosts.add(tempHost);
        } else {
            hosts = this.getDNSATypeResult(tempHost);
        }
        int port = uriToFind.hasPort() ? uriToFind.getPort() : 5060;
        String transport = uriToFind.getTransport();
        if (transport == null) {
            transport = "udp";
        } else if (uriToFind.getScheme().equalsIgnoreCase("sips")) {
            transport = "tls";
        }
        for (String host : hosts) {
            Hop hop = new Hop(transport, host, port);
            retVal.add(hop);
        }
        return retVal;
    }

    private List getDNSSrvTypeResults(SipURL uriToFind) throws UnknownHostException {
        ArrayList<Hop> retval = new ArrayList<Hop>(2);
        String domain = uriToFind.getHost();
        String transport = uriToFind.getTransport();
        if (transport == null) {
            transport = "udp";
        } else if (uriToFind.getScheme().equalsIgnoreCase("sips")) {
            transport = "tls";
        }
        StringBuffer buf = new StringBuffer("_");
        buf.append(SIP_SERVICE);
        buf.append("._");
        buf.append(transport);
        buf.append(".");
        buf.append(domain);
        String qname = buf.toString();
        try {
            Attributes attr = this.m_context.getAttributes(qname, new String[]{QTYPE_SRV});
            Attribute srvRes = attr.getAll().next();
            if (srvRes == null || srvRes.size() == 0) {
                throw new UnknownHostException(uriToFind.toString());
            }
            if (srvRes.size() == 1) {
                // empty if block
            }
            ArrayList<DNSSRVQueryResult> resultsList = new ArrayList<DNSSRVQueryResult>(attr.size());
            NamingEnumeration<?> na = srvRes.getAll();
            while (na.hasMore()) {
                DNSSRVQueryResult res = new DNSSRVQueryResult(SIP_SERVICE, transport, (String)na.next());
                resultsList.add(res);
            }
            Collections.sort(resultsList);
            for (DNSSRVQueryResult res : resultsList) {
                Hop srvHop = new Hop(transport, res.hostName, res.port);
                retval.add(srvHop);
            }
        }
        catch (NamingException ne) {
            throw new UnknownHostException(uriToFind.toString());
        }
        return retval;
    }

    public List getDNSATypeResult(String host) throws UnknownHostException {
        ArrayList retVal = new ArrayList(3);
        try {
            Attributes attr = this.m_context.getAttributes(host, new String[]{QTYPE_ADDRESS});
            Attribute aRes = attr.get(QTYPE_ADDRESS);
            if (aRes == null || aRes.size() == 0) {
                throw new UnknownHostException(host);
            }
            NamingEnumeration<?> na = aRes.getAll();
            while (na.hasMore()) {
                retVal.add(na.next());
            }
        }
        catch (NamingException ne) {
            throw new UnknownHostException(host);
        }
        return retVal;
    }

    @Override
    public Hop getOutboundProxy() {
        return null;
    }

    @Override
    public void processRequest(Request req) throws SipParseException {
    }

    @Override
    public void removeConnectionHop(Hop value) {
    }

    @Override
    public void setOutboundProxy(Hop proxy) {
    }
}

