/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.annotation;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import java.lang.reflect.Method;
import javax.servlet.sip.SipServletRequest;

public class ApplicationKeyHelper {
    private static final LogMgr c_logger = Log.get(SipAppDesc.class);
    Object objectToInvoke = null;
    Method applicationKeyMethod = null;
    String applicationKeyMethodstr = null;
    String applicationKeyClassName = null;

    private ApplicationKeyHelper() {
    }

    public ApplicationKeyHelper(Method applicationKeyMethod) {
        this.applicationKeyMethodstr = applicationKeyMethod.getName();
        this.applicationKeyClassName = applicationKeyMethod.getDeclaringClass().getName();
    }

    public String generateApplicationKey(SipServletRequest req) {
        String result;
        block6: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "generateApplicationKey");
            }
            result = null;
            try {
                Object methodResult;
                if (this.objectToInvoke == null || this.applicationKeyMethod == null) {
                    this.uploadAppKeyMethod();
                }
                if ((methodResult = this.applicationKeyMethod.invoke(this.objectToInvoke, req)) != null) {
                    result = methodResult.toString();
                }
            }
            catch (Throwable e2) {
                if (!c_logger.isErrorEnabled()) break block6;
                Object[] args = new Object[]{};
                c_logger.error(e2.getMessage(), "Request", args, e2);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{result};
            c_logger.traceExit((Object)this, "generateApplicationKey", params);
        }
        return result;
    }

    private void uploadAppKeyMethod() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(this.applicationKeyClassName, true, Thread.currentThread().getContextClassLoader());
        this.applicationKeyMethod = clazz.getMethod(this.applicationKeyMethodstr, SipServletRequest.class);
        this.objectToInvoke = this.applicationKeyMethod.getDeclaringClass().newInstance();
    }
}

