/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.ViaHeader;
import java.net.InetAddress;

public class ViaHeaderImpl
extends ParametersHeaderImpl
implements ViaHeader {
    private static final long serialVersionUID = -8826491277443321888L;
    public static final String BRANCH = "branch";
    public static final String HIDDEN = "hidden";
    public static final String RECEIVED = "received";
    public static final String RPORT = "rport";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    public static final int TTL_MIN = 1;
    public static final int TTL_MAX = 255;
    public static final String TLS = "TLS";
    public static final String SCTP = "SCTP";
    private static final String IBMADDRESS = "ibmaddress";
    private String m_host;
    private int m_port = -1;
    private String m_comment;
    private String m_protocolVersion = "2.0";
    private String m_transport = "UDP";
    private final boolean m_compactForm;

    public ViaHeaderImpl() {
        this(false);
    }

    public ViaHeaderImpl(boolean compactForm) {
        this.m_compactForm = compactForm;
    }

    @Override
    public boolean isHidden() {
        return this.hasParameter(HIDDEN);
    }

    @Override
    public void setHidden(boolean hidden) {
        if (hidden) {
            if (!this.hasParameter(HIDDEN)) {
                try {
                    this.setParameter(HIDDEN, HIDDEN);
                }
                catch (SipParseException e2) {
                    e2.printStackTrace();
                }
            }
        } else {
            this.removeParameter(HIDDEN);
        }
    }

    @Override
    public boolean hasPort() {
        return this.m_port != -1;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public void setPort(int port) throws SipParseException {
        if (port <= 0) {
            throw new SipParseException("Negative port", "" + port);
        }
        this.m_port = port;
    }

    @Override
    public void removePort() {
        this.m_port = -1;
    }

    @Override
    public String getProtocolVersion() {
        return this.m_protocolVersion;
    }

    @Override
    public void setProtocolVersion(String protocolVersion) throws IllegalArgumentException, SipParseException {
        if (protocolVersion == null) {
            throw new IllegalArgumentException("Protocol version null");
        }
        this.m_protocolVersion = protocolVersion;
    }

    @Override
    public String getTransport() {
        return this.m_transport;
    }

    @Override
    public void setTransport(String transport) throws IllegalArgumentException, SipParseException {
        if (transport == null) {
            throw new IllegalArgumentException("Null transport");
        }
        this.m_transport = transport.equalsIgnoreCase("TCP") ? "TCP" : (transport.equalsIgnoreCase("UDP") ? "UDP" : (transport.equalsIgnoreCase(TLS) ? TLS : (transport.equalsIgnoreCase(SCTP) ? SCTP : transport)));
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public void setHost(String host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Via: Null host");
        }
        this.m_host = host;
    }

    @Override
    public void setHost(InetAddress host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Via: null host");
        }
        this.m_host = InetAddressCache.getHostAddress(host);
    }

    @Override
    public String getComment() {
        return this.m_comment;
    }

    @Override
    public boolean hasComment() {
        return this.m_comment != null;
    }

    @Override
    public void setComment(String comment) throws IllegalArgumentException, SipParseException {
        if (comment == null) {
            throw new IllegalArgumentException("Via: null comment");
        }
        if (comment.length() == 0) {
            throw new IllegalArgumentException("Via: empty comment");
        }
        this.m_comment = comment;
    }

    @Override
    public void removeComment() {
        this.m_comment = null;
    }

    @Override
    public void setTTL(int ttl) throws SipParseException {
        if (1 <= ttl && ttl <= 255) {
            try {
                this.setParameter(TTL, String.valueOf(ttl));
            }
            catch (SipParseException e2) {
                e2.printStackTrace();
            }
        } else {
            throw new SipParseException("Via: invalid ttl");
        }
    }

    @Override
    public void removeTTL() {
        this.removeParameter(TTL);
    }

    @Override
    public int getTTL() {
        String ttl = this.getParameter(TTL);
        if (ttl == null) {
            return -1;
        }
        return Integer.parseInt(ttl);
    }

    @Override
    public boolean hasTTL() {
        return this.hasParameter(TTL);
    }

    @Override
    public void setMAddr(String mAddr) throws IllegalArgumentException, SipParseException {
        if (mAddr == null) {
            throw new IllegalArgumentException("Via: null mAddr");
        }
        try {
            this.setParameter(MADDR, mAddr);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setMAddr(InetAddress mAddr) throws IllegalArgumentException, SipParseException {
        if (mAddr == null) {
            throw new IllegalArgumentException("Via: null mAddr");
        }
        String host = InetAddressCache.getHostAddress(mAddr);
        if (host == null) {
            throw new IllegalArgumentException("Via: null host address");
        }
        try {
            this.setParameter(MADDR, host);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public boolean hasMAddr() {
        return this.hasParameter(MADDR);
    }

    @Override
    public void removeMAddr() {
        this.removeParameter(MADDR);
    }

    @Override
    public String getMAddr() {
        return this.getParameter(MADDR);
    }

    @Override
    public void setReceived(String received) throws IllegalArgumentException, SipParseException {
        if (received == null) {
            throw new IllegalArgumentException("Via: Null received");
        }
        try {
            this.setParameter(RECEIVED, received);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setReceived(InetAddress received) throws IllegalArgumentException, SipParseException {
        if (received == null) {
            throw new IllegalArgumentException("Via: null received");
        }
        String host = received.getHostName();
        if (host == null) {
            throw new IllegalArgumentException("Via: null host");
        }
        try {
            this.setParameter(RECEIVED, host);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void removeReceived() {
        this.removeParameter(RECEIVED);
    }

    @Override
    public String getReceived() {
        return this.getParameter(RECEIVED);
    }

    @Override
    public boolean hasReceived() {
        return this.hasParameter(RECEIVED);
    }

    @Override
    public void setBranch(String branch) throws IllegalArgumentException, SipParseException {
        if (branch == null) {
            throw new IllegalArgumentException("Via: null branch");
        }
        try {
            this.setParameter(BRANCH, branch);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void removeBranch() {
        this.removeParameter(BRANCH);
    }

    @Override
    public String getBranch() {
        return this.getParameter(BRANCH);
    }

    @Override
    public boolean hasBranch() {
        return this.hasParameter(BRANCH);
    }

    public void setRPort(int rport) {
        String value = rport == -1 ? "" : Integer.toString(rport);
        try {
            this.setParameter(RPORT, value);
        }
        catch (SipParseException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void setRPort() {
        this.setRPort(-1);
    }

    @Override
    public int getRPort() {
        int rport;
        String rportParam = this.getParameter(RPORT);
        if (rportParam == null || rportParam.length() == 0) {
            rport = -1;
        } else {
            try {
                rport = Integer.parseInt(rportParam);
            }
            catch (NumberFormatException e2) {
                rport = -1;
            }
        }
        return rport;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        int colonIdx;
        String host;
        parser.skip('/');
        parser.lws();
        String protVersion = parser.parseSipVersion('/');
        this.setProtocolVersion(protVersion);
        parser.lws();
        parser.match('/');
        String transport = parser.nextToken(' ');
        this.setTransport(transport);
        parser.lws();
        if (parser.LA() == '[') {
            parser.consume();
            host = parser.nextToken(']');
            parser.consume();
        } else {
            char[] separators = new char[]{':', ';'};
            host = parser.nextToken(separators);
        }
        this.setHost(host.trim());
        if (parser.LA(1) == ':') {
            parser.match(':');
            parser.lws();
            this.setPort(parser.number());
            parser.lws();
        } else {
            this.removePort();
        }
        super.parseValue(parser);
        String address = this.getParameter(IBMADDRESS);
        if (address != null && address.length() > 0 && (colonIdx = address.lastIndexOf(58)) > -1) {
            try {
                String portStr = address.substring(colonIdx + 1);
                int port = Integer.parseInt(portStr);
                this.setPort(port);
                String ibmHost = address.substring(0, colonIdx);
                if (ibmHost.charAt(0) == '[') {
                    ibmHost = ibmHost.substring(1, ibmHost.length() - 1);
                }
                this.setHost(ibmHost);
            }
            catch (NumberFormatException e2) {
                throw new RuntimeException(e2);
            }
            catch (IllegalArgumentException e3) {
                throw new RuntimeException(e3);
            }
        }
        if (parser.LA(1) == '(') {
            parser.match('(');
            this.setComment(parser.nextToken(')'));
            parser.match(')');
        } else {
            this.removeComment();
        }
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        boolean ipv6;
        ret.append("SIP");
        ret.append('/');
        ret.append(this.m_protocolVersion);
        ret.append('/');
        ret.append(this.m_transport);
        ret.append(' ');
        boolean bl = ipv6 = this.m_host.indexOf(58) != -1;
        if (ipv6) {
            ret.append('[');
        }
        ret.append(this.m_host);
        if (ipv6) {
            ret.append(']');
        }
        if (this.hasPort()) {
            ret.append(':');
            ret.append(this.m_port);
        }
        super.encodeValue(ret);
        if (this.hasComment()) {
            ret.append('(');
            ret.append(this.m_comment);
            ret.append(')');
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof ViaHeaderImpl)) {
            return false;
        }
        ViaHeaderImpl o = (ViaHeaderImpl)other;
        if (this.m_port != o.m_port) {
            return false;
        }
        if (this.m_host == null || this.m_host.length() == 0 ? o.m_host != null && o.m_host.length() > 0 : o.m_host == null || o.m_host.length() == 0) {
            return false;
        }
        if (this.m_transport == null || this.m_transport.length() == 0 ? o.m_transport != null && o.m_transport.length() > 0 : o.m_transport == null || o.m_transport.length() == 0) {
            return false;
        }
        if (this.m_protocolVersion == null || this.m_protocolVersion.length() == 0 ? o.m_protocolVersion != null && o.m_protocolVersion.length() > 0 : o.m_protocolVersion == null || o.m_protocolVersion.length() == 0) {
            return false;
        }
        if (this.m_comment == null || this.m_comment.length() == 0) {
            return o.m_comment == null || o.m_comment.length() == 0;
        }
        if (o.m_comment == null || o.m_comment.length() == 0) {
            return false;
        }
        return this.m_comment.equals(o.m_comment);
    }

    @Override
    public String getName() {
        return "Via";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }

    @Override
    protected boolean escapeParameters() {
        return false;
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        if (isUseCompactHeaders) {
            return String.valueOf('v');
        }
        return this.getName();
    }

    @Override
    public boolean isCompactFormSupported() {
        return true;
    }

    @Override
    public boolean isCompactForm() {
        return this.m_compactForm;
    }
}

