/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.sip.parser.CharArray;
import com.ibm.ws.sip.parser.Separators;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.parser.util.ObjectPool;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.Header;
import java.util.HashSet;

public abstract class HeaderImpl
implements Header,
Separators {
    private static final long serialVersionUID = -4001774780461425221L;
    private static final LogMgr s_logger = Log.get(HeaderImpl.class);
    private static ObjectPool s_parsersPool = new ObjectPool(SipParser.class);
    private CharArray m_value;

    public HeaderImpl() {
        this(null);
    }

    public HeaderImpl(CharArray value) {
        this.m_value = value;
    }

    @Override
    public void setValue(String value) throws IllegalArgumentException, SipParseException {
        if (value == null) {
            throw new IllegalArgumentException("Header: null value");
        }
        CharArray newValue = CharArray.getFromPool(value);
        this.setValue(newValue);
    }

    public final void setValue(CharArray value) {
        if (this.m_value != null) {
            this.m_value.returnToPool();
        }
        this.m_value = value;
    }

    @Override
    public abstract String getName();

    public String getName(boolean isUseCompactHeaders) {
        return this.getName();
    }

    @Override
    public final String getValue() {
        if (this.m_value == null) {
            return this.encodeValue();
        }
        int length = this.m_value.getLength();
        return length > 0 ? String.valueOf(this.m_value.getArray(), 0, length) : "";
    }

    protected final String encodeValue() {
        CharsBuffer writer = CharsBuffersPool.getBuffer();
        this.encodeValue(writer);
        String value = writer.toString();
        CharsBuffersPool.putBufferBack(writer);
        return value;
    }

    protected void encodeValue(CharsBuffer writer) {
        if (this.m_value == null) {
            return;
        }
        int length = this.m_value.getLength();
        if (length > 0) {
            writer.append(this.m_value.getArray(), length);
        }
    }

    public boolean isCompactFormSupported() {
        return false;
    }

    public boolean isCompactForm() {
        return false;
    }

    @Override
    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeNameToCharBuffer(buffer, MessageImpl.HeaderForm.DEFAULT);
        this.writeValueToCharBuffer(buffer, false);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeNameToCharBuffer(CharsBuffer buffer, MessageImpl.HeaderForm headerForm) {
        boolean compact;
        switch (headerForm) {
            case COMPACT: {
                compact = true;
                break;
            }
            case LONG: {
                compact = false;
                break;
            }
            default: {
                compact = this.isCompactForm();
            }
        }
        String name = this.getName(compact);
        buffer.append(name);
        buffer.append(':');
        if (!compact) {
            buffer.append(' ');
        }
    }

    public void writeValueToCharBuffer(CharsBuffer buffer, boolean network) {
        boolean hide;
        if (network) {
            hide = false;
        } else {
            HashSet<String> hiddenHeaders = SIPTransactionStack.instance().getConfiguration().getHiddenHeaders();
            String fullFormName = this.getName();
            hide = hiddenHeaders.contains(fullFormName);
        }
        if (hide) {
            buffer.append("<hidden value>");
        } else {
            this.writeValueToCharBuffer(buffer);
        }
    }

    public final void writeValueToCharBuffer(CharsBuffer buffer) {
        if (this.m_value == null) {
            this.encodeValue(buffer);
        } else {
            int length = this.m_value.getLength();
            if (length > 0) {
                buffer.append(this.m_value.getArray(), length);
            }
        }
    }

    public int hashCode() {
        int valueHash;
        int nameHash = this.getName().hashCode();
        if (this.m_value == null) {
            CharsBuffer buffer = CharsBuffersPool.getBuffer();
            this.writeValueToCharBuffer(buffer);
            valueHash = buffer.hashCode();
            CharsBuffersPool.putBufferBack(buffer);
        } else {
            valueHash = this.m_value.hashCode();
        }
        int hash = nameHash ^ valueHash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HeaderImpl)) {
            return false;
        }
        HeaderImpl other = (HeaderImpl)obj;
        if (!HeaderImpl.headerNamesEqual(this.getName(), other.getName())) {
            return false;
        }
        if (this.m_value == null) {
            if (other.m_value == null) {
                return this.valueEquals(other);
            }
            CharsBuffer thisOne = CharsBuffersPool.getBuffer();
            this.encodeValue(thisOne);
            char[] thisChars = thisOne.getCharArray();
            int thisCharsSize = thisOne.getCharCount();
            CharArray thatOne = other.m_value;
            boolean equal = thatOne.equals(thisChars, thisCharsSize);
            CharsBuffersPool.putBufferBack(thisOne);
            return equal;
        }
        if (other.m_value == null) {
            CharsBuffer thatOne = CharsBuffersPool.getBuffer();
            other.encodeValue(thatOne);
            char[] thatChars = thatOne.getCharArray();
            int thatCharsSize = thatOne.getCharCount();
            CharArray thisOne = this.m_value;
            boolean equal = thisOne.equals(thatChars, thatCharsSize);
            CharsBuffersPool.putBufferBack(thatOne);
            return equal;
        }
        return this.m_value.equals(other.m_value);
    }

    public static boolean headerNamesEqual(String h1, String h2) {
        if (h1.length() == 1) {
            h1 = HeaderImpl.getFullFormHeaderName(h1);
        }
        if (h2.length() == 1) {
            h2 = HeaderImpl.getFullFormHeaderName(h2);
        }
        return h1.equalsIgnoreCase(h2);
    }

    private static String getFullFormHeaderName(String name) {
        switch (name.charAt(0)) {
            case 'T': 
            case 't': {
                return "To";
            }
            case 'F': 
            case 'f': {
                return "From";
            }
            case 'I': 
            case 'i': {
                return "Call-ID";
            }
            case 'M': 
            case 'm': {
                return "Contact";
            }
            case 'L': 
            case 'l': {
                return "Content-Length";
            }
            case 'V': 
            case 'v': {
                return "Via";
            }
            case 'E': 
            case 'e': {
                return "Content-Encoding";
            }
            case 'C': 
            case 'c': {
                return "Content-Type";
            }
            case 'K': 
            case 'k': {
                return "Supported";
            }
            case 'S': 
            case 's': {
                return "Subject";
            }
            case 'O': 
            case 'o': {
                return "Event";
            }
            case 'U': 
            case 'u': {
                return "Allow-Events";
            }
            case 'R': 
            case 'r': {
                return "Refer-To";
            }
            case 'X': 
            case 'x': {
                return "Session-Expires";
            }
        }
        return name;
    }

    protected abstract boolean valueEquals(HeaderImpl var1);

    public abstract boolean isNested();

    @Override
    public Object clone() {
        try {
            HeaderImpl ret = (HeaderImpl)super.clone();
            ret.m_value = this.m_value == null ? null : (CharArray)this.m_value.clone();
            return ret;
        }
        catch (CloneNotSupportedException e2) {
            throw new Error("Clone not supported?");
        }
    }

    public boolean isParsed() {
        return this.m_value == null;
    }

    public final void parse() throws SipParseException {
        if (this.m_value == null) {
            return;
        }
        int length = this.m_value.getLength();
        if (length < 0) {
            length = 0;
        }
        SipParser parser = (SipParser)s_parsersPool.get();
        if ("To".equals(this.getName()) || "From".equals(this.getName()) || "Contact".equals(this.getName()) || this.shouldBeParsedAsAddress(this.getName())) {
            parser.setParseHeaderParameters(true);
        } else {
            parser.setParseHeaderParameters(false);
        }
        parser.setSrc(this.m_value.getArray(), length);
        this.parseValue(parser);
        parser.rewind();
        s_parsersPool.putBack(parser);
        this.m_value.returnToPool();
        this.m_value = null;
    }

    private boolean shouldBeParsedAsAddress(String headerName) {
        HashSet<String> addressHeaders = SIPTransactionStack.instance().getConfiguration().getAddressHeaders();
        boolean result = addressHeaders.contains(headerName.toLowerCase());
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "shouldBeParsedAsAddress", headerName + " " + result);
        }
        return result;
    }

    protected abstract void parseValue(SipParser var1) throws SipParseException;
}

