/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryResultCategory;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.RetryState;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.DurationUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.PrimitiveIterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RetryStateImpl
implements RetryState {
    private final RetryPolicy policy;
    private final PrimitiveIterator.OfLong delayStream;
    private int attempts = 0;
    private long startNanos;
    private final MetricRecorder metricRecorder;
    static final long serialVersionUID = 2070809579114657068L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RetryStateImpl(RetryPolicy policy, MetricRecorder metricRecorder) {
        this.policy = policy;
        this.delayStream = RetryStateImpl.createDelayStream(policy.getDelay(), policy.getJitter());
        this.metricRecorder = metricRecorder;
    }

    @Override
    public void start() {
        this.startNanos = System.nanoTime();
    }

    @Override
    public RetryState.RetryResult recordResult(MethodResult<?> methodResult) {
        RetryResultCategory retryResultCategory = null;
        ++this.attempts;
        long duration = System.nanoTime() - this.startNanos;
        retryResultCategory = methodResult.isFailure() ? (this.abortOn(methodResult.getFailure()) ? RetryResultCategory.EXCEPTION_IN_ABORT_ON : (this.retryOn(methodResult.getFailure()) ? RetryResultCategory.EXCEPTION_IN_RETRY_ON : RetryResultCategory.EXCEPTION_NOT_IN_RETRY_ON)) : RetryResultCategory.NO_EXCEPTION;
        boolean resultWasRetryableFailure = RetryStateImpl.shouldRetry(retryResultCategory);
        if (resultWasRetryableFailure) {
            int maxAttempts = this.policy.getMaxRetries() + 1;
            if (maxAttempts != 0 && this.attempts >= maxAttempts) {
                retryResultCategory = RetryResultCategory.MAX_RETRIES_REACHED;
            } else if (this.overMaxDuration(duration)) {
                retryResultCategory = RetryResultCategory.MAX_DURATION_REACHED;
            }
        }
        if (RetryStateImpl.shouldRetry(retryResultCategory)) {
            this.metricRecorder.incrementRetriesCount();
        } else {
            this.metricRecorder.incrementRetryCalls(retryResultCategory, this.attempts > 1 ? MetricRecorder.RetriesOccurred.WITH_RETRIES : MetricRecorder.RetriesOccurred.NO_RETRIES);
        }
        return this.createResult(retryResultCategory);
    }

    private boolean overMaxDuration(long duration) {
        return !this.policy.getMaxDuration().isZero() && Duration.ofNanos(duration).compareTo(this.policy.getMaxDuration()) >= 0;
    }

    private boolean abortOn(Throwable failure) {
        for (Class abortClazz : this.policy.getAbortOn()) {
            if (!abortClazz.isInstance(failure)) continue;
            return true;
        }
        return false;
    }

    private boolean retryOn(Throwable failure) {
        for (Class retryClazz : this.policy.getRetryOn()) {
            if (!retryClazz.isInstance(failure)) continue;
            return true;
        }
        return false;
    }

    private RetryResultImpl createResult(RetryResultCategory retryResultCategory) {
        long delay = 0L;
        if (RetryStateImpl.shouldRetry(retryResultCategory) && (delay = this.delayStream.nextLong()) < 0L) {
            delay = 0L;
        }
        return new RetryResultImpl(retryResultCategory, delay, TimeUnit.NANOSECONDS);
    }

    private static boolean shouldRetry(RetryResultCategory category) {
        return category == RetryResultCategory.EXCEPTION_IN_RETRY_ON;
    }

    protected static PrimitiveIterator.OfLong createDelayStream(Duration delay, Duration jitter) {
        if (jitter.isZero()) {
            long delayNanos = DurationUtils.asClampedNanos(delay);
            return LongStream.generate(() -> delayNanos).iterator();
        }
        long lowerLimitNanos = DurationUtils.asClampedNanos(delay.minus(jitter));
        long upperLimitNanos = DurationUtils.asClampedNanos(delay.plus(jitter));
        return ThreadLocalRandom.current().longs(lowerLimitNanos, upperLimitNanos).iterator();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.RetryStateImpl", RetryStateImpl.class, (String)"FAULTTOLERANCE", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RetryResultImpl
    implements RetryState.RetryResult {
        private final RetryResultCategory retryResultCategory;
        private final long delay;
        private final TimeUnit delayUnit;
        static final long serialVersionUID = 6886578338149190529L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RetryResultImpl(RetryResultCategory reason, long delay, TimeUnit delayUnit) {
            this.retryResultCategory = reason;
            this.delay = delay;
            this.delayUnit = delayUnit;
        }

        @Override
        public boolean shouldRetry() {
            return RetryStateImpl.shouldRetry(this.retryResultCategory);
        }

        @Override
        public long getDelay() {
            return this.delay;
        }

        @Override
        public TimeUnit getDelayUnit() {
            return this.delayUnit;
        }

        @Override
        public RetryResultCategory getCategory() {
            return this.retryResultCategory;
        }

        @Override
        public String toString() {
            return this.retryResultCategory.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.RetryStateImpl$RetryResultImpl", RetryResultImpl.class, (String)"FAULTTOLERANCE", null);
        }
    }
}

