/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.bridge;

import com.ibm.jbatch.container.ws.BatchDispatcher;
import com.ibm.jbatch.container.ws.BatchDispatcherException;
import com.ibm.jbatch.container.ws.BatchInternalDispatcher;
import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Properties;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={BatchDispatcher.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=2", "type=Local"})
public class BatchLocalDispatcher
implements BatchDispatcher {
    private BatchInternalDispatcher internalDispatcher;
    private BatchEventsPublisher eventsPublisher;
    static final long serialVersionUID = -7762443637732342796L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setBatchInternalDispatcher(BatchInternalDispatcher ref) {
        this.internalDispatcher = ref;
    }

    protected void unsetInternalDispatcher(BatchInternalDispatcher svc) {
        if (svc == this.internalDispatcher) {
            this.internalDispatcher = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        this.eventsPublisher = publisher;
    }

    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void start(WSJobInstance jobInstance, Properties jobParameters, long executionId) throws JobStartException, JobSecurityException {
        try {
            this.internalDispatcher.start(jobInstance, jobParameters, executionId);
        }
        catch (JobStartException jobStartException) {
            void je;
            FFDCFilter.processException((Throwable)jobStartException, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"111", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
            this.markInstanceExecutionFailed(jobInstance.getInstanceId(), executionId, this.getCorrelationId(jobParameters));
            throw je;
        }
        catch (JobSecurityException je) {
            void jse;
            FFDCFilter.processException((Throwable)je, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"114", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
            this.markInstanceExecutionFailed(jobInstance.getInstanceId(), executionId, this.getCorrelationId(jobParameters));
            throw jse;
        }
        catch (RuntimeException jse) {
            void rte;
            FFDCFilter.processException((Throwable)jse, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"117", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
            this.markInstanceExecutionFailed(jobInstance.getInstanceId(), executionId, this.getCorrelationId(jobParameters));
            throw rte;
        }
        catch (Exception rte) {
            FFDCFilter.processException((Throwable)rte, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"120", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
            this.markInstanceExecutionFailed(jobInstance.getInstanceId(), executionId, this.getCorrelationId(jobParameters));
        }
    }

    public void markInstanceExecutionFailed(long jobInstanceId, long executionId, String correlationId) {
        if (this.internalDispatcher.getJobInstance(jobInstanceId).getBatchStatus() == BatchStatus.ABANDONED) {
            return;
        }
        this.internalDispatcher.markInstanceExecutionFailed(jobInstanceId, executionId);
        this.publishEvent(jobInstanceId, "batch/jobs/instance/failed", correlationId);
        this.publishExecutionEvent(executionId, "batch/jobs/execution/failed", correlationId);
    }

    /*
     * WARNING - void declaration
     */
    public void restartInstance(long instanceId, Properties restartParameters, long executionId) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        try {
            this.internalDispatcher.restartInstance(instanceId, restartParameters, executionId);
        }
        catch (JobRestartException jobRestartException) {
            void jre;
            FFDCFilter.processException((Throwable)jobRestartException, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"157", (Object)this, (Object[])new Object[]{instanceId, restartParameters, executionId});
            this.markInstanceExecutionFailed(instanceId, executionId, this.getCorrelationId(restartParameters));
            throw jre;
        }
        catch (JobSecurityException jre) {
            void jse;
            FFDCFilter.processException((Throwable)jre, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"160", (Object)this, (Object[])new Object[]{instanceId, restartParameters, executionId});
            this.markInstanceExecutionFailed(instanceId, executionId, this.getCorrelationId(restartParameters));
            throw jse;
        }
        catch (Exception jse) {
            FFDCFilter.processException((Throwable)jse, (String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", (String)"163", (Object)this, (Object[])new Object[]{instanceId, restartParameters, executionId});
            this.markInstanceExecutionFailed(instanceId, executionId, this.getCorrelationId(restartParameters));
        }
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException, BatchDispatcherException, BatchJobNotLocalException {
        this.internalDispatcher.stop(executionId);
    }

    public void startPartition(PartitionPlanConfig partitionPlanConfig, Step step, PartitionReplyQueue partitionReplyQueue) {
        this.internalDispatcher.startPartition(partitionPlanConfig, step, partitionReplyQueue);
    }

    public PartitionReplyQueue createPartitionReplyQueue() throws BatchDispatcherException {
        throw new IllegalStateException("Invalid call to BatchLocalDispatcher.createPartitionReplyQueue");
    }

    private void publishEvent(long instanceId, String event, String correlationId) {
        WSJobInstance updatedInstance;
        if (this.eventsPublisher != null && (updatedInstance = this.internalDispatcher.getJobInstance(instanceId)) != null) {
            this.eventsPublisher.publishJobInstanceEvent(updatedInstance, event, correlationId);
        }
    }

    private void publishExecutionEvent(long executionId, String event, String correlationId) {
        WSJobExecution updatedExecution;
        if (this.eventsPublisher != null && (updatedExecution = this.internalDispatcher.getJobExecution(executionId)) != null) {
            this.eventsPublisher.publishJobExecutionEvent(updatedExecution, event, correlationId);
        }
    }

    private String getCorrelationId(Properties jobParameters) {
        if (jobParameters != null) {
            return jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.bridge.BatchLocalDispatcher", BatchLocalDispatcher.class, (String)"wsbatch", null);
    }
}

