/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.storage;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebSSOUtils;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import io.openliberty.security.oidcclientcore.storage.CookieStorageProperties;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageProperties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CookieBasedStorage
implements Storage {
    public static final TraceComponent tc = Tr.register(CookieBasedStorage.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    HttpServletRequest request;
    HttpServletResponse response;
    WebSSOUtils webSsoUtils = new WebSSOUtils();
    ReferrerURLCookieHandler referrerURLCookieHandler;
    static final long serialVersionUID = -3340121046474057899L;

    public CookieBasedStorage(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, null);
    }

    public CookieBasedStorage(HttpServletRequest request, HttpServletResponse response, ReferrerURLCookieHandler referrerURLCookieHandler) {
        this.request = request;
        this.response = response;
        this.referrerURLCookieHandler = referrerURLCookieHandler != null ? referrerURLCookieHandler : this.webSsoUtils.getCookieHandler();
    }

    @Override
    public void store(String name, @Sensitive String value) {
        this.store(name, value, null);
    }

    @Override
    public void store(String name, @Sensitive String value, StorageProperties properties) {
        Cookie c = this.referrerURLCookieHandler.createCookie(name, value, this.request);
        String domainName = this.webSsoUtils.getSsoDomain(this.request);
        if (domainName != null && !domainName.isEmpty()) {
            c.setDomain(domainName);
        }
        if (properties != null) {
            this.setAdditionalCookieProperties(c, (CookieStorageProperties)properties);
        }
        this.response.addCookie(c);
    }

    @Override
    @Sensitive
    public String get(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No cookies were sent by the client.", (Object[])new Object[0]);
            }
            return null;
        }
        for (Cookie c : cookies) {
            if (!c.getName().equals(name)) continue;
            return c.getValue();
        }
        return null;
    }

    @Override
    public void remove(String name) {
        if (name == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CookieBasedStorage.remove param is null, return", (Object[])new Object[0]);
            }
            return;
        }
        Cookie c = this.referrerURLCookieHandler.createCookie(name, "", this.request);
        String domainName = this.webSsoUtils.getSsoDomain(this.request);
        if (domainName != null && !domainName.isEmpty()) {
            c.setDomain(domainName);
        }
        c.setMaxAge(0);
        this.response.addCookie(c);
    }

    private void setAdditionalCookieProperties(Cookie cookie, CookieStorageProperties cookieProps) {
        if (cookieProps.isSecureSet()) {
            cookie.setSecure(cookieProps.isSecure());
        }
        if (cookieProps.isHttpOnlySet()) {
            cookie.setHttpOnly(cookieProps.isHttpOnly());
        }
        cookie.setMaxAge(cookieProps.getStorageLifetimeSeconds());
    }
}

