/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestUtils;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AuthorizationRequest {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String clientId;
    protected Storage storage;
    protected AuthorizationRequestUtils requestUtils = new AuthorizationRequestUtils();
    protected OidcStorageUtils storageUtils = new OidcStorageUtils();
    static final long serialVersionUID = 5805694948134499294L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AuthorizationRequest(HttpServletRequest request, HttpServletResponse response, String clientId) {
        this.request = request;
        this.response = response;
        this.clientId = clientId;
    }

    public ProviderAuthenticationResult sendRequest() throws OidcClientConfigurationException, OidcDiscoveryException {
        this.getAuthorizationEndpoint();
        this.createSessionIfNecessary();
        String state = this.requestUtils.generateStateValue(this.request);
        this.storeStateValue(state);
        String redirectUrl = this.getRedirectUrl();
        return this.redirectToAuthorizationEndpoint(state, redirectUrl);
    }

    protected abstract String getAuthorizationEndpoint() throws OidcClientConfigurationException, OidcDiscoveryException;

    protected abstract String getRedirectUrl() throws OidcClientConfigurationException;

    protected abstract boolean shouldCreateSession();

    protected abstract String createStateValueForStorage(String var1);

    protected abstract String createNonceValueForStorage(String var1, String var2);

    protected abstract ProviderAuthenticationResult redirectToAuthorizationEndpoint(String var1, String var2);

    protected StorageProperties getStateStorageProperties() {
        StorageProperties props = new StorageProperties();
        props.setStorageLifetimeSeconds(420);
        return props;
    }

    protected StorageProperties getNonceStorageProperties() {
        StorageProperties props = new StorageProperties();
        props.setStorageLifetimeSeconds(420);
        return props;
    }

    protected StorageProperties getOriginalRequestUrlStorageProperties() {
        StorageProperties props = new StorageProperties();
        props.setStorageLifetimeSeconds(420);
        return props;
    }

    protected void storeStateValue(String state) {
        String storageName = OidcStorageUtils.getStateStorageKey(state);
        String storageValue = this.createStateValueForStorage(state);
        StorageProperties stateStorageProperties = this.getStateStorageProperties();
        this.storage.store(storageName, storageValue, stateStorageProperties);
    }

    protected void storeNonceValue(String nonce, String state) {
        String storageName = OidcStorageUtils.getNonceStorageKey(this.clientId, state);
        String storageValue = this.createNonceValueForStorage(nonce, state);
        StorageProperties nonceStorageProperties = this.getNonceStorageProperties();
        this.storage.store(storageName, storageValue, nonceStorageProperties);
    }

    protected void storeOriginalRequestUrl(String state) {
        String storageName = OidcStorageUtils.getOriginalReqUrlStorageKey(state);
        String storageValue = this.requestUtils.getRequestUrl(this.request);
        StorageProperties reqUrlStorageProperties = this.getOriginalRequestUrlStorageProperties();
        this.storage.store(storageName, storageValue, reqUrlStorageProperties);
    }

    void createSessionIfNecessary() {
        if (this.shouldCreateSession()) {
            try {
                this.request.getSession(true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.security.oidcclientcore.authentication.AuthorizationRequest", (String)"110", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.authentication.AuthorizationRequest", AuthorizationRequest.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

