/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;

public class SetSupport
extends BodyTagSupport {
    protected Object value;
    protected boolean valueSpecified;
    protected Object target;
    protected String property;
    private String var;
    private int scope;
    private boolean scopeSpecified;

    public SetSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.value = null;
        this.valueSpecified = false;
        this.scopeSpecified = false;
        this.scope = 1;
    }

    public void release() {
        super.release();
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        Object result = this.value != null ? this.value : (this.valueSpecified ? null : (this.bodyContent == null || this.bodyContent.getString() == null ? "" : this.bodyContent.getString().trim()));
        if (this.var != null) {
            ELContext myELContext = this.pageContext.getELContext();
            VariableMapper vm = myELContext.getVariableMapper();
            if (result != null) {
                if (result instanceof ValueExpression) {
                    if (this.scope != 1) {
                        throw new JspException("Incorrect scope for ValueExpression.  PageScope is required.");
                    }
                    vm.setVariable(this.var, (ValueExpression)result);
                    return 6;
                } else {
                    this.pageContext.setAttribute(this.var, result, this.scope);
                }
                return 6;
            } else {
                if (vm.resolveVariable(this.var) != null) {
                    vm.setVariable(this.var, null);
                }
                if (this.scopeSpecified) {
                    this.pageContext.removeAttribute(this.var, this.scope);
                    return 6;
                } else {
                    this.pageContext.removeAttribute(this.var);
                }
            }
            return 6;
        } else {
            if (this.target == null) throw new JspTagException();
            if (this.target instanceof Map) {
                if (result == null) {
                    ((Map)this.target).remove(this.property);
                    return 6;
                } else {
                    ((Map)this.target).put(this.property, result);
                }
                return 6;
            } else {
                try {
                    PropertyDescriptor[] pd = Introspector.getBeanInfo(this.target.getClass()).getPropertyDescriptors();
                    boolean succeeded = false;
                    for (int i = 0; i < pd.length; ++i) {
                        if (!pd[i].getName().equals(this.property)) continue;
                        Method m = pd[i].getWriteMethod();
                        if (m == null) {
                            throw new JspException(Resources.getMessage("SET_NO_SETTER_METHOD", this.property));
                        }
                        if (result != null) {
                            try {
                                m.invoke(this.target, this.convertToExpectedType(result, m.getParameterTypes()[0]));
                            }
                            catch (ELException ex) {
                                throw new JspTagException((Throwable)ex);
                            }
                        } else {
                            m.invoke(this.target, new Object[]{null});
                        }
                        succeeded = true;
                    }
                    if (succeeded) return 6;
                    throw new JspTagException(Resources.getMessage("SET_INVALID_PROPERTY", this.property));
                }
                catch (IllegalAccessException ex) {
                    throw new JspException((Throwable)ex);
                }
                catch (IntrospectionException ex) {
                    throw new JspException((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    throw new JspException((Throwable)ex);
                }
            }
        }
    }

    private Object convertToExpectedType(Object value, Class expectedType) throws ELException {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        ExpressionFactory expressionFactory = jspFactory.getJspApplicationContext(this.pageContext.getServletContext()).getExpressionFactory();
        return expressionFactory.coerceToType(value, expectedType);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
        this.scopeSpecified = true;
    }
}

