/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.AttributeToSubject;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.oauth20.UserCredentialResolver;
import com.ibm.wsspi.security.oauth20.UserIdentityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class AttributeToSubjectExt
extends AttributeToSubject {
    public static final TraceComponent tc = Tr.register(AttributeToSubject.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    public static final String JOBJ_TYPE = "jobj";
    public static final String PAYLOAD_TYPE = "payload";
    public static final String KEY_USER_RESOLVER = "userResolver";
    static ConcurrentServiceReferenceMap<String, UserCredentialResolver> activatedUserResolverRef = new ConcurrentServiceReferenceMap("userResolver");
    static final long serialVersionUID = 2364491014757989785L;

    public static void setActivatedUserResolverRef(ConcurrentServiceReferenceMap<String, UserCredentialResolver> userResolverRef) {
        activatedUserResolverRef = userResolverRef;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activatedUserResolverRef size():" + activatedUserResolverRef.size()), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={UserIdentityException.class, IOException.class})
    AttributeToSubjectExt(OidcClientConfig clientConfig, JSONObject jobj, String accessToken) {
        this.earlyinit((ConvergedClientConfig)clientConfig, accessToken);
        String jobjStr = null;
        if (this.isTokenMappingSpi()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activatedUserResolverRef size():" + activatedUserResolverRef.size()), (Object[])new Object[0]);
            }
            try {
                jobjStr = jobj.serialize();
                this.getTheTokenMappingFromSpi(jobjStr, clientConfig);
            }
            catch (IOException e) {
                Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INTERNAL_ERR", (Object[])new Object[]{e.getLocalizedMessage(), clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl()});
                return;
            }
            catch (UserIdentityException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SPI implementation throws an exception for user mapping!!", (Object[])new Object[]{jobj.toString()});
                }
                Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INTERNAL_ERR", (Object[])new Object[]{e.getLocalizedMessage(), clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl()});
                return;
            }
        }
        this.initialize((ConvergedClientConfig)clientConfig, jobj, accessToken);
    }

    protected boolean isTokenMappingSpi() {
        return activatedUserResolverRef.size() > 0;
    }

    protected void getTheTokenMappingFromSpi(String jobjStr, OidcClientConfig clientConfig) throws UserIdentityException {
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            this.userName = userIdResolver.mapToUser(jobjStr);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"spi returns user id = ", (Object[])new Object[]{this.userName});
            }
            if (!clientConfig.isMapIdentityToRegistryUser()) {
                List groups;
                this.realm = userIdResolver.mapToRealm(jobjStr);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"spi returns the realm = ", (Object[])new Object[]{this.realm});
                }
                this.uniqueSecurityName = userIdResolver.mapToUserUniqueID(jobjStr);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"spi returns the unique security name = ", (Object[])new Object[]{this.uniqueSecurityName});
                }
                if ((groups = userIdResolver.mapToGroups(jobjStr)) != null && !groups.isEmpty()) {
                    this.groupIds = new ArrayList(groups);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"spi returns the groups and size = ", (Object[])new Object[]{this.groupIds.size()});
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    AttributeToSubjectExt(OidcClientConfig clientConfig, OidcTokenImplBase idToken) {
        super((ConvergedClientConfig)clientConfig, idToken);
        if (this.isTokenMappingSpi()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activatedUserResolverRef size():" + activatedUserResolverRef.size()), (Object[])new Object[0]);
            }
            try {
                this.getTheTokenMappingFromSpi(idToken.getAllClaimsAsJson(), clientConfig);
            }
            catch (UserIdentityException userIdentityException) {
                void e;
                FFDCFilter.processException((Throwable)userIdentityException, (String)"com.ibm.ws.security.openidconnect.client.internal.AttributeToSubjectExt", (String)"128", (Object)((Object)this), (Object[])new Object[]{clientConfig, idToken});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SPI implementation throws an exception for user mapping!!", (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INTERNAL_ERR", (Object[])new Object[]{e.getLocalizedMessage(), clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl()});
                return;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.client.internal.AttributeToSubjectExt", (String)"134", (Object)((Object)this), (Object[])new Object[]{clientConfig, idToken});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SPI implementation throws an exception for user mapping!!", (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INTERNAL_ERR", (Object[])new Object[]{e.getLocalizedMessage(), clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl()});
                return;
            }
        }
    }
}

