/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.execution.impl;

import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.ws.TopLevelNameInstanceExecutionInfo;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.smf.ZosJBatchSMFLogging;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RuntimeJobExecution
extends RuntimeWorkUnitExecution {
    private static final String sourceClass = RuntimeJobExecution.class.getName();
    protected static final Logger logger = Logger.getLogger(sourceClass);
    protected String restartOnForThisExecution;
    private final Properties jobParameters;
    byte[] timeUsedBefore;
    static final long serialVersionUID = -4403187068389105165L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeJobExecution(TopLevelNameInstanceExecutionInfo topLevelInfo, Properties jobParameters, String restartOn, ModelNavigator<JSLJob> navigator) {
        super(navigator, topLevelInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "<init>", new Object[]{topLevelInfo, jobParameters, restartOn, navigator});
        }
        this.timeUsedBefore = null;
        this.restartOnForThisExecution = restartOn;
        this.jobParameters = jobParameters;
        this.type = WorkUnitDescriptor.WorkUnitType.TOP_LEVEL_JOB;
        if (jobParameters != null) {
            this.correlationId = jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeJobExecution(TopLevelNameInstanceExecutionInfo topLevelInfo, Properties jobParameters, ModelNavigator<JSLJob> navigator) {
        this(topLevelInfo, jobParameters, null, navigator);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "<init>", new Object[]{topLevelInfo, jobParameters, navigator});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "<init>", this);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getExecutionLogMessage(RuntimeWorkUnitExecution.MessageType msgType) {
        RuntimeWorkUnitExecution.LogHelper lh = new RuntimeWorkUnitExecution.LogHelper(this);
        StringBuilder buf = lh.getBeginningPart(msgType);
        buf.append("invoking execution for a job");
        buf.append("\n JobInstance id = ");
        buf.append(this.getTopLevelNameInstanceExecutionInfo().getInstanceId());
        buf.append("\n JobExecution id = ");
        buf.append(this.getTopLevelNameInstanceExecutionInfo().getExecutionId());
        buf.append("\n Job Name = ");
        buf.append(this.getTopLevelNameInstanceExecutionInfo().getJobName());
        if (this.jobParameters != null) {
            buf.append("\n Job Parameters = ");
            buf.append(this.jobParameters);
        }
        if (!msgType.equals((Object)RuntimeWorkUnitExecution.MessageType.STARTED)) {
            buf.append("\n Job Batch Status = " + this.getBatchStatus());
            buf.append(", Job Exit Status = " + this.getExitStatus());
        }
        buf.append("\n==========================================================\n");
        return buf.toString();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Logger getClassNameLogger() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getClassNameLogger", new Object[0]);
        }
        Logger logger = RuntimeJobExecution.logger;
        if (RuntimeJobExecution.logger != null && RuntimeJobExecution.logger.isLoggable(Level.FINER)) {
            logger = logger;
            RuntimeJobExecution.logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getClassNameLogger", logger);
        }
        return logger;
    }

    @Override
    public String toString() {
        return "Superclass info: " + super.toString() + "; " + this.getTopLevelNameInstanceExecutionInfo();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRestartOnForThisExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getRestartOnForThisExecution", new Object[0]);
        }
        String string = this.restartOnForThisExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getRestartOnForThisExecution", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Properties getJobParameters() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getJobParameters", new Object[0]);
        }
        Properties properties = this.jobParameters;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            properties = properties;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getJobParameters", properties);
        }
        return properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ZosJBatchSMFLogging getJBatchSMFLoggingService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getJBatchSMFLoggingService", new Object[0]);
        }
        ZosJBatchSMFLogging zosJBatchSMFLogging = ServicesManagerStaticAnchor.getServicesManager().getJBatchSMFService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            zosJBatchSMFLogging = zosJBatchSMFLogging;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "getJBatchSMFLoggingService", zosJBatchSMFLogging);
        }
        return zosJBatchSMFLogging;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workStarted(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "workStarted", new Object[]{date});
        }
        if (this.batchStatus.equals((Object)BatchStatus.STARTING)) {
            this.batchStatus = BatchStatus.STARTED;
            WSJobExecution execution = (WSJobExecution)this.getPersistenceManagerService().updateJobExecutionAndInstanceOnStarted(this.getTopLevelExecutionId(), new Date());
            this.publishEvent(execution, execution.getJobInstance(), this.batchStatus);
        } else {
            logger.fine("No-op on workStarted() since batch status is set to: " + this.batchStatus);
        }
        ZosJBatchSMFLogging smflogger = this.getJBatchSMFLoggingService();
        if (smflogger != null) {
            this.timeUsedBefore = this.getJBatchSMFLoggingService().getTimeUsedData();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "workStarted");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobInstance objectToPublish, String eventToPublish) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "publishEvent", new Object[]{objectToPublish, eventToPublish});
        }
        if (this.getBatchEventsPublisher() != null) {
            this.getBatchEventsPublisher().publishJobInstanceEvent(objectToPublish, eventToPublish, this.correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "publishEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobExecution objectToPublish, String eventToPublishTo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "publishEvent", new Object[]{objectToPublish, eventToPublishTo});
        }
        if (this.getBatchEventsPublisher() != null) {
            this.getBatchEventsPublisher().publishJobExecutionEvent(objectToPublish, eventToPublishTo, this.correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "publishEvent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workStopping(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "workStopping", new Object[]{date});
        }
        if (!(this.batchStatus.equals((Object)BatchStatus.COMPLETED) || this.batchStatus.equals((Object)BatchStatus.FAILED) || this.batchStatus.equals((Object)BatchStatus.ABANDONED))) {
            this.batchStatus = BatchStatus.STOPPING;
            WSJobExecution execution = (WSJobExecution)this.getPersistenceManagerService().updateJobExecutionAndInstanceOnStatusChange(this.getTopLevelExecutionId(), BatchStatus.STOPPING, new Date());
            JobInstanceEntity jobInstance = this.getPersistenceManagerService().getJobInstanceFromExecutionId(execution.getExecutionId());
            this.publishEvent(execution, jobInstance, this.batchStatus);
        } else {
            logger.fine("No-op on workStopping() since batch status is set to: " + this.batchStatus);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "workStopping");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workEnded(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "workEnded", new Object[]{date});
        }
        WSJobExecution execution = (WSJobExecution)this.getPersistenceManagerService().updateJobExecutionAndInstanceOnEnd(this.getTopLevelExecutionId(), this.batchStatus, this.exitStatus, new Date());
        ZosJBatchSMFLogging smflogger = this.getJBatchSMFLoggingService();
        if (smflogger != null) {
            byte[] timeUsedAfter = this.getJBatchSMFLoggingService().getTimeUsedData();
            this.getJBatchSMFLoggingService().buildAndWriteJobEndRecord(execution, this, this.getPersistenceManagerService().getPersistenceType(), this.getPersistenceManagerService().getDisplayId(), this.timeUsedBefore, timeUsedAfter);
        }
        this.publishEvent(execution, execution.getJobInstance(), this.batchStatus);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "workEnded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobExecution execution, WSJobInstance jobInstance, BatchStatus batchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "publishEvent", new Object[]{execution, jobInstance, batchStatus});
        }
        if (batchStatus == BatchStatus.FAILED) {
            this.publishEvent(execution, "batch/jobs/execution/failed");
            this.publishEvent(jobInstance, "batch/jobs/instance/failed");
        } else if (batchStatus == BatchStatus.COMPLETED) {
            this.publishEvent(execution, "batch/jobs/execution/completed");
            this.publishEvent(jobInstance, "batch/jobs/instance/completed");
        } else if (batchStatus == BatchStatus.STOPPED) {
            this.publishEvent(execution, "batch/jobs/execution/stopped");
            this.publishEvent(jobInstance, "batch/jobs/instance/stopped");
        } else if (batchStatus == BatchStatus.STOPPING) {
            this.publishEvent(jobInstance, "batch/jobs/instance/stopping");
            this.publishEvent(execution, "batch/jobs/execution/stopping");
        } else if (batchStatus == BatchStatus.STARTED) {
            this.publishEvent(jobInstance, "batch/jobs/instance/dispatched");
            this.publishEvent(execution, "batch/jobs/execution/started");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "publishEvent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateExecutionJobLogDir(String logDirPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "updateExecutionJobLogDir", new Object[]{logDirPath});
        }
        this.getPersistenceManagerService().updateJobExecutionLogDir(this.getTopLevelExecutionId(), logDirPath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "updateExecutionJobLogDir");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRemotePartitionDispatch() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "isRemotePartitionDispatch", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeJobExecution", "isRemotePartitionDispatch", bl);
        }
        return bl;
    }
}

