/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.failsafe.Predicates;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.Predicate;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.ClosedState;
import net.jodah.failsafe.internal.HalfOpenState;
import net.jodah.failsafe.internal.OpenState;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;
import net.jodah.failsafe.util.Ratio;

public class CircuitBreaker {
    private final AtomicReference<CircuitState> state = new AtomicReference();
    private final AtomicInteger currentExecutions = new AtomicInteger();
    private final CircuitBreakerStats stats = new CircuitBreakerStats(){

        @Override
        public int getCurrentExecutions() {
            return CircuitBreaker.this.currentExecutions.get();
        }
    };
    private Duration delay = Duration.NONE;
    private Duration timeout;
    private Ratio failureThreshold;
    private Ratio successThreshold;
    private boolean failuresChecked;
    private List<BiPredicate<Object, Throwable>> failureConditions = new ArrayList<BiPredicate<Object, Throwable>>();
    CheckedRunnable onOpen;
    CheckedRunnable onHalfOpen;
    CheckedRunnable onClose;

    public CircuitBreaker() {
        this.state.set(new ClosedState(this));
    }

    public boolean allowsExecution() {
        return this.state.get().allowsExecution(this.stats);
    }

    public void close() {
        this.transitionTo(State.CLOSED, this.onClose);
    }

    public <T> CircuitBreaker failIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.failuresChecked = true;
        this.failureConditions.add(completionPredicate);
        return this;
    }

    public <T> CircuitBreaker failIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.failureConditions.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public CircuitBreaker failOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.failOn(Arrays.asList(failure));
    }

    public CircuitBreaker failOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "failures cannot be empty", new Object[0]);
        return this.failOn(Arrays.asList(failures));
    }

    public CircuitBreaker failOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.failuresChecked = true;
        this.failureConditions.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public CircuitBreaker failOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failuresChecked = true;
        this.failureConditions.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public CircuitBreaker failWhen(Object result) {
        this.failureConditions.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Ratio getFailureThreshold() {
        return this.failureThreshold;
    }

    public State getState() {
        return this.state.get().getState();
    }

    public Ratio getSuccessThreshold() {
        return this.successThreshold;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void halfOpen() {
        this.transitionTo(State.HALF_OPEN, this.onHalfOpen);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.getState());
    }

    public boolean isFailure(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.failureConditions) {
            if (!predicate.test(result, failure)) continue;
            return true;
        }
        return failure != null && !this.failuresChecked;
    }

    public boolean isHalfOpen() {
        return State.HALF_OPEN.equals((Object)this.getState());
    }

    public boolean isOpen() {
        return State.OPEN.equals((Object)this.getState());
    }

    public CircuitBreaker onClose(CheckedRunnable runnable) {
        this.onClose = runnable;
        return this;
    }

    public CircuitBreaker onHalfOpen(CheckedRunnable runnable) {
        this.onHalfOpen = runnable;
        return this;
    }

    public CircuitBreaker onOpen(CheckedRunnable runnable) {
        this.onOpen = runnable;
        return this;
    }

    public void open() {
        this.transitionTo(State.OPEN, this.onOpen);
    }

    public void recordFailure(Throwable failure) {
        this.recordResult(null, failure);
    }

    public void recordResult(Object result) {
        this.recordResult(result, null);
    }

    public void recordSuccess() {
        try {
            this.state.get().recordSuccess();
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    public String toString() {
        return this.getState().toString();
    }

    public CircuitBreaker withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(delay > 0L, "delay must be greater than 0", new Object[0]);
        this.delay = new Duration(delay, timeUnit);
        return this;
    }

    public CircuitBreaker withFailureThreshold(int failureThreshold) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be greater than or equal to 1", new Object[0]);
        return this.withFailureThreshold(failureThreshold, failureThreshold);
    }

    public synchronized CircuitBreaker withFailureThreshold(int failures, int executions) {
        Assert.isTrue(failures >= 1, "failures must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= 1, "executions must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= failures, "executions must be greater than or equal to failures", new Object[0]);
        this.failureThreshold = new Ratio(failures, executions);
        this.state.get().setFailureThreshold(this.failureThreshold);
        return this;
    }

    public CircuitBreaker withSuccessThreshold(int successThreshold) {
        Assert.isTrue(successThreshold >= 1, "successThreshold must be greater than or equal to 1", new Object[0]);
        return this.withSuccessThreshold(successThreshold, successThreshold);
    }

    public synchronized CircuitBreaker withSuccessThreshold(int successes, int executions) {
        Assert.isTrue(successes >= 1, "successes must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= 1, "executions must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= successes, "executions must be greater than or equal to successes", new Object[0]);
        this.successThreshold = new Ratio(successes, executions);
        this.state.get().setSuccessThreshold(this.successThreshold);
        return this;
    }

    public CircuitBreaker withTimeout(long timeout, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(timeout > 0L, "timeout must be greater than 0", new Object[0]);
        this.timeout = new Duration(timeout, timeUnit);
        return this;
    }

    void before() {
        this.currentExecutions.incrementAndGet();
    }

    void recordFailure() {
        try {
            this.state.get().recordFailure();
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    void recordResult(Object result, Throwable failure) {
        try {
            if (this.isFailure(result, failure)) {
                this.state.get().recordFailure();
            } else {
                this.state.get().recordSuccess();
            }
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionTo(State newState, CheckedRunnable listener) {
        boolean transitioned = false;
        CircuitBreaker circuitBreaker = this;
        synchronized (circuitBreaker) {
            if (!this.getState().equals((Object)newState)) {
                switch (newState) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this));
                        break;
                    }
                    case OPEN: {
                        this.state.set(new OpenState(this));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this));
                    }
                }
                transitioned = true;
            }
        }
        if (transitioned && listener != null) {
            try {
                listener.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

