/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.archive.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIRuntimeException;
import com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl;
import com.ibm.ws.cdi.internal.archive.liberty.ExtensionContainerInfo;
import com.ibm.ws.cdi.internal.archive.liberty.RuntimeFactory;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchive;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.Extension;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExtensionArchiveImpl
extends CDIArchiveImpl
implements ExtensionArchive {
    private static final TraceComponent tc = Tr.register(ExtensionArchiveImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final ExtensionContainerInfo extensionContainerInfo;
    private Set<String> spiExtensions = null;
    private Set<String> preConstructedExtensionNames = new HashSet<String>();
    private Set<Supplier<Extension>> extraSPIExtensionSuppliers = new HashSet<Supplier<Extension>>();
    static final long serialVersionUID = -8383123613855911947L;

    public ExtensionArchiveImpl(ExtensionContainerInfo extensionContainerInfo, RuntimeFactory factory, Set<String> spiExtensions) throws CDIException {
        super(null, extensionContainerInfo, ArchiveType.RUNTIME_EXTENSION, extensionContainerInfo.getClassLoader(), factory);
        this.extensionContainerInfo = extensionContainerInfo;
        this.spiExtensions = spiExtensions;
    }

    @Override
    public Set<String> getExtraClasses() {
        return this.extensionContainerInfo.getExtraClasses();
    }

    @Override
    public Set<String> getExtraBeanDefiningAnnotations() {
        return this.extensionContainerInfo.getExtraBeanDefiningAnnotations();
    }

    @Override
    public boolean applicationBDAsVisible() {
        return this.extensionContainerInfo.applicationBDAsVisible();
    }

    @Override
    public boolean isExtClassesOnly() {
        return this.extensionContainerInfo.isExtClassesOnly();
    }

    @Override
    public Set<String> getExtensionClasses() {
        Set<String> extensionClasses = super.getExtensionClasses();
        extensionClasses.addAll(this.spiExtensions);
        extensionClasses.addAll(this.preConstructedExtensionNames);
        return extensionClasses;
    }

    @Override
    public Set<Supplier<Extension>> getSPIExtensionSuppliers() {
        if (this.spiExtensions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Supplier<Extension>> result = new HashSet<Supplier<Extension>>();
        for (String className : this.spiExtensions) {
            result.add(() -> {
                try {
                    Class<?> clazz = this.getClassLoader().loadClass(className);
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Object extension = constructor.newInstance(new Object[0]);
                    if (!(extension instanceof Extension)) {
                        throw new IllegalArgumentException(extension.getClass().getCanonicalName() + " was registered as an extension via the WebSphereCDIExtensionMetaData interface. But it does not implement javax.enterprise.inject.spi.Extension");
                    }
                    return (Extension)extension;
                }
                catch (Exception e) {
                    Tr.error((TraceComponent)tc, (String)"spi.extension.failed.to.construct.CWOWB1010E", (Object[])new Object[]{className, e.toString()});
                    throw new CDIRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"spi.extension.failed.to.construct.CWOWB1010E", (Object[])new Object[]{className, e.toString()}), (Throwable)e);
                }
            });
        }
        result.addAll(this.extraSPIExtensionSuppliers);
        return result;
    }

    public void addConstructedExtension(Extension preConstructedExtension) {
        this.extraSPIExtensionSuppliers.add(() -> preConstructedExtension);
        this.preConstructedExtensionNames.add(preConstructedExtension.getClass().getCanonicalName());
    }
}

