/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.util.EventListenerV;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.EventListener;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventListeners {
    private static final EventListener[] EMPTY_LISTENERS = new EventListener[0];
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.EventListeners";
    private EventListener[] listeners = EMPTY_LISTENERS;

    public final EventListener[] getListenerArray() {
        return this.listeners;
    }

    public final void fireEvent(EventObject evt, EventListenerV visitor) {
        EventListener[] list = this.getListenerArray();
        for (int i = 0; i < list.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "fireEvent", "Use visitor " + visitor + " to fire event to " + list[i] + ", class:" + list[i].getClass());
            }
            visitor.fireEvent(evt, list[i]);
        }
    }

    public final int getListenerCount() {
        return this.listeners.length;
    }

    public final synchronized void addListener(EventListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener " + l + " is null");
        }
        if (this.listeners == EMPTY_LISTENERS) {
            this.listeners = new EventListener[1];
            this.listeners[0] = l;
        } else {
            int i = this.listeners.length;
            EventListener[] tmp = new EventListener[i + 1];
            System.arraycopy(this.listeners, 0, tmp, 0, i);
            tmp[i] = l;
            this.listeners = tmp;
        }
    }

    public final synchronized void removeListener(EventListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener " + l + " is null");
        }
        int index = -1;
        for (int i = this.listeners.length - 1; i >= 0; --i) {
            if (!this.listeners[i].equals(l)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            EventListener[] tmp = new EventListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listeners, index + 1, tmp, index, tmp.length - index);
            }
            this.listeners = tmp.length == 0 ? EMPTY_LISTENERS : tmp;
        }
    }

    public String toString() {
        EventListener[] lList = this.getListenerArray();
        String s = "EventListenerList: ";
        s = s + this.getListenerCount() + " listeners: ";
        for (int i = 0; i < lList.length; ++i) {
            s = s + " listener " + lList[i] + "\n";
        }
        return s;
    }
}

